﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Thread.h>

namespace {

char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));

void TestThreadCore(int32_t idealCore)
{
    AutoThreadExit autoExit;
    ASSERT_TRUE(idealCore == nn::svc::GetCurrentProcessorNumber());
}

} // namespace

TEST(GetCurrentProcessorNumber, EqualYmlIdealProcessor)
{
    // TEST 14-1
    // yml ファイルに書かれているコア番号と取得した値が一致することを確認
    ASSERT_TRUE(nn::svc::GetCurrentProcessorNumber() == 1);
}

TEST(GetCurrentProcessorNumber, EqualThreadIdealCore)
{
    nn::Result result;
    nn::svc::Handle handle;
    uintptr_t pc;
    uintptr_t sp;
    int32_t index;

    pc = reinterpret_cast<uintptr_t>(TestThreadCore);
    sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));

    // TEST 14-2
    // スレッドの生成時に指定したidealCore と取得した値が一致することを確認
    for(int32_t idealCore = 0; idealCore < NumCore; idealCore++)
    {
        result = nn::svc::CreateThread(&handle, pc, static_cast<uintptr_t>(idealCore),
                sp, TestLowestThreadPriority, idealCore);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::StartThread(handle);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
}

