﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_TestIpc.h"
#include "test_ForceDebug.h"
#include <nn/svc/svc_Thread.h>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/os/os_UserExceptionHandler.h>
#include <nn/init.h>

int32_t g_ProcessIdealCore;
uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

namespace {
char g_UserException[DefaultStackSize] __attribute__((aligned(0x1000)));

}

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    InitTestMemory();
    nn::Result result;

    // ユーザー例外ハンドラを無効化
    nn::os::SetUserExceptionHandler(nullptr,
            g_UserException,
            DefaultStackSize,
            nn::os::UserExceptionInfoUsesHandlerStack);

    nn::svc::Handle clientSession;
    result = nn::svc::ConnectToNamedPort(&clientSession, ForceDebugPortName);
    NN_ASSERT_RESULT_SUCCESS(result);

    bool forceDebug;
    ClientReceiveData(&forceDebug, sizeof(forceDebug), clientSession);

    // EnableDebug がついていたらデバッグ出来る
    {
        nn::Bit32 flags[DefaultCapabilityFlagNum + 1];
        SetDefaultCapability(flags, DefaultCapabilityFlagNum);
        MakeNo16Flag(&flags[DefaultCapabilityFlagNum], 1 << 0);
        TestProcess process(1, 0, flags, DefaultCapabilityFlagNum + 1);

        nn::Bit64 pid;
        result = nn::svc::GetProcessId(&pid, process.GetHandle());
        NN_ASSERT_RESULT_SUCCESS(result);

        nn::svc::Handle debugHandle;
        result = nn::svc::DebugActiveProcess(&debugHandle, pid);
        NN_ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose debugCloser(debugHandle);
    }

    // EnableDebug がついていなかったら、 ForceDebug が付いていないとデバッグ出来ない
    {
        nn::Bit32 flags[DefaultCapabilityFlagNum + 1];
        SetDefaultCapability(flags, DefaultCapabilityFlagNum);
        int flag = forceDebug ? (1 << 1) : 0;
        MakeNo16Flag(&flags[DefaultCapabilityFlagNum], flag);
        TestProcess process(1, 0, flags, DefaultCapabilityFlagNum + 1);

        nn::Bit64 pid;
        result = nn::svc::GetProcessId(&pid, process.GetHandle());
        NN_ASSERT_RESULT_SUCCESS(result);

        nn::svc::Handle debugHandle;
        result = nn::svc::DebugActiveProcess(&debugHandle, pid);
        if (forceDebug)
        {
            NN_ASSERT_RESULT_SUCCESS(result);
            AutoHandleClose debugCloser(debugHandle);
        }
        else
        {
            NN_ASSERT_RESULT_FAILURE(result);
        }
    }

}

