﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/nn_Assert.h>
#include <nn/init.h>

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

namespace {
const uint64_t SleepTime = 1000000000;
const int NumPriority = TestLowestThreadPriority - TestHighestThreadPriority + 1;
const size_t StackSize = 0x1000;

void TestFunc(uintptr_t arg)
{
    AutoThreadExit autoExit;
    // TEST 6-4
    // ExitProcess が呼ばれると出力が出なくなる
    // 全てのスレッドの出力が出力されなくてよい
    for(;;)
    {
        NN_LOG("Thread[%d] is alive.\n", arg);
        nn::svc::SleepThread(SleepTime);
    }
}
} // namespace

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
    InitTestMemory();

    nn::svc::Handle *handle;
    nn::Result result;
    uintptr_t pc = reinterpret_cast<uintptr_t>(TestFunc);
    uintptr_t sp;
    uintptr_t heapPtr;
    size_t wantSize = (sizeof(nn::svc::Handle) + StackSize) * NumPriority;
    size_t heapSize = (HeapAlign >= wantSize)
        ? HeapAlign : (wantSize + HeapAlign - 1) & ~(HeapAlign - 1);

    result = nn::svc::SetHeapSize(&heapPtr, heapSize);
    NN_ASSERT_RESULT_SUCCESS(result);

    handle = reinterpret_cast<nn::svc::Handle*>(heapPtr);
    sp = heapPtr + heapSize;

    uint32_t idealCore = 0;
    for (uint32_t priority = TestHighestThreadPriority;
        priority <= TestLowestThreadPriority;
        priority++, idealCore++)
    {
        uint32_t index = priority - TestHighestThreadPriority;
        result = nn::svc::CreateThread(
            &handle[index], pc, priority,
            sp - index * StackSize, priority, idealCore % NumCore);
        NN_ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::StartThread(handle[index]);
        NN_ASSERT_RESULT_SUCCESS(result);
    }

    // TEST 6-1
    // プロセスを終了させることが出来る
    NN_LOG("Call ExitProcess.\n");
    nn::svc::ExitProcess();

    // TEST 6-2
    // ExitProcess 呼び出し後の命令は実行されない
    NN_LOG("Do not print this sentence.\n");
    NN_ASSERT(false);
}

