﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_DebugProcess_Register.h"
#include <nn/svc/svc_Thread.h>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/os/os_UserExceptionHandler.h>
#include <nn/init.h>

int32_t g_ProcessIdealCore;
uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern nn::Result TestHoge();

namespace {
char g_Stack[DefaultStackSize] __attribute__((aligned(0x1000)));
char g_UserException[DefaultStackSize] __attribute__((aligned(0x1000)));

void TestThreadFunc(uintptr_t arg)
{
    AutoThreadExit autoExit;

    nn::Result result;
    nn::svc::Handle clientSession = *reinterpret_cast<nn::svc::Handle*>(arg);

    // 通常時
    asm volatile ("loop: b loop");

    // SVC 中
    nn::Bit32* pMsgBuffer = nn::svc::ipc::GetMessageBuffer();
    nn::svc::ipc::MessageBuffer ipcMsg(pMsgBuffer);

    ipcMsg.SetNull();
    result = nn::svc::SendSyncRequest(clientSession);
    NN_ASSERT_RESULT_SUCCESS(result);

    // ReturnFromException と Break は別扱い
    nn::svc::ReturnFromException(nn::ResultSuccess());

    // Break
    nn::svc::Break(nn::svc::BreakReason_User, 0, 0);

    // 例外中
    int* p = reinterpret_cast<int*>(0x4);
    *p = 0;

    // ユーザーが書き換えられない
    asm volatile ("loop2: b loop2");
}

} // namespace

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    InitTestMemory();
    nn::Result result;

    // ユーザー例外ハンドラを無効化
    nn::os::SetUserExceptionHandler(nullptr,
            g_UserException,
            DefaultStackSize,
            nn::os::UserExceptionInfoUsesHandlerStack);

    nn::svc::Handle clientSession;
    result = nn::svc::ConnectToNamedPort(&clientSession, DebugPortName);
    NN_ASSERT_RESULT_SUCCESS(result);

    nn::svc::Handle handle;
    uintptr_t pc = reinterpret_cast<uintptr_t>(TestThreadFunc);
    uintptr_t sp = reinterpret_cast<uintptr_t>(g_Stack) + DefaultStackSize;
    uintptr_t param = reinterpret_cast<uintptr_t>(&clientSession);
    int32_t priority = TestLowestThreadPriority;
    int32_t idealCore = 0;

    NN_LOG("pc: 0x%p\n", pc);
    NN_LOG("sp: 0x%p\n", sp);

    TestThread thread(pc, param, sp, priority, idealCore);
    thread.Start();

    thread.Wait();
}

