﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Dd.h>

// TEST 80-1
// 共有メモリを作成できる
TEST(CreateSharedMemory, NormalCase)
{
    TestSharedMemoryLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    size_t size = 0x1000;
    nn::svc::MemoryPermission myPermission = nn::svc::MemoryPermission_ReadWrite;
    nn::svc::MemoryPermission otherPermission = nn::svc::MemoryPermission_ReadWrite;

    result = nn::svc::CreateSharedMemory(&handle, size, myPermission, otherPermission);
    ASSERT_RESULT_SUCCESS(result);

    // 正常なハンドルかを確認
    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);
}

#ifdef ENABLE_MAX_HANDLE_TEST
TEST(CreateSharedMemory, MaxHandleTest)
{
    TestSharedMemoryLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    size_t size = 0x1000;
    nn::svc::MemoryPermission myPermission = nn::svc::MemoryPermission_ReadWrite;
    nn::svc::MemoryPermission otherPermission = nn::svc::MemoryPermission_ReadWrite;

    {
        ConsumeHandle maxHandle;

        // TEST 80-26
        // ハンドル数が上限を超えていると失敗する
        result = nn::svc::CreateSharedMemory(&handle, size, myPermission, otherPermission);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultMaxHandle());
    }

    // TEST 80-27
    // ハンドルを解放すれば、再度共有メモリを作成できる
    result = nn::svc::CreateSharedMemory(&handle, size, myPermission, otherPermission);
    ASSERT_RESULT_SUCCESS(result);

    AutoHandleClose handleCloser(handle);
}
#endif // ENABLE_MAX_HANDLE_TEST

