﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <cstring>

namespace {
}
extern "C" void nnMain();


// TEST 121-81
// 作成したハンドルを、使わずに閉じることが出来る
// TEST 121-82
// 使わずに閉じた後、また、プロセスを作成できる
// TEST 121-85
// 作成・クローズを繰り返しても、ハンドルのリソースリークを起こさない

// 正常系
//  Process上限値以上にループさせて、リークしていないことを確認。
TEST(CreateProcess, Test0)
{
    TestProcessLeak leakTest;
    nn::Result result;
    int i;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    for (i = 0; i < 1023; i++)
    {
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = NN_SVC_ADDR_SMALL_MAP32_BEGIN + 0x00200000 * (i % 64);
        param.memoryNumPages = 0x00000100;
        param.flags          = 0x00000000;



        nn::Bit32 flags[DefaultCapabilityFlagNum];
        SetDefaultCapability(flags, DefaultCapabilityFlagNum);

        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 121-101
        //  作成したプロセスの memoryAddress/memoryNumPages の領域は MemoryState_Code / MemoryPermission_None になる
        result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), param.memoryAddress);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(blockInfo.baseAddress == param.memoryAddress);
        ASSERT_TRUE(blockInfo.size == static_cast<size_t>(param.memoryNumPages * 0x1000));
        ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
        ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
}

// TEST 121-12
// param.memoryAddress は 2MB にアライメントされていないと失敗する
TEST(CreateProcess, Test1)
{
    TestProcessLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    {
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = NN_SVC_ADDR_SMALL_MAP32_BEGIN + 0x00100000;
        param.memoryNumPages = 0x00001000;
        param.flags          = 0x00000000;

        nn::Bit32 flags[DefaultCapabilityFlagNum];
        SetDefaultCapability(flags, DefaultCapabilityFlagNum);

        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidAddress());
    }
}


