﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <nn/svc/ipc/svc_SessionMessage.h>

extern nn::Result ClientLightSession(nn::svc::Handle handle);
extern nn::Result ServerLightSession(nn::svc::Handle handle);
extern "C" void nnMain();

namespace {

} // namespace

#ifdef ENABLE_MAX_HANDLE_TEST
TEST(CreatePort, MaxHandleTest)
{
    TestPortLeak leakTest;
    nn::Result result;

    nn::svc::Handle serverPort;
    nn::svc::Handle clientPort;

    // ハンドル数が上限に達していると失敗する
    {
        ConsumeHandle maxHandle;

        // TEST 112-25
        // Normal Session
        result = nn::svc::CreatePort(&serverPort, &clientPort, 1, false, 0);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultMaxHandle());

        // TEST 112-26
        // Light Session
        result = nn::svc::CreatePort(&serverPort, &clientPort, 1, true, 0);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultMaxHandle());
    }

    // ハンドルが解放されると、再度作成できるようになる
    {
        // TEST 112-25
        // Normal Session
        result = nn::svc::CreatePort(&serverPort, &clientPort, 1, false, 0);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(serverPort);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(clientPort);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 112-26
        // Light Session
        result = nn::svc::CreatePort(&serverPort, &clientPort, 1, true, 0);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(serverPort);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(clientPort);
        ASSERT_RESULT_SUCCESS(result);
    }
}
#endif //ENABLE_MAX_HANDLE_TEST
