﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_HardwareParamsSelect.h>
#include <nn/svc/svc_InterruptNameSelect.h>
#include <nn/svc/svc_MemoryMapSelect.h>
#include <nn/util/util_BitPack.h>
#include <nn/svc/svc_Dd.h>
#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
#include "test_TestTmrDevice_Jetson.h"
#endif

#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )

namespace {

extern "C" void nnMain();

} // namespace

#ifdef ENABLE_MAX_HANDLE_TEST
TEST(CreateInterruptEvent, MaxHandleTest)
{
    TestInterruptEventLeak leakTest;
    nn::Result result;
    nn::svc::Handle eventHandle;
    nn::svc::InterruptType type = nn::svc::InterruptType_Level;
#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
    int32_t name = TmrDefaultInterruptNumber;
#else
#error not implemented
#endif

    {
        ConsumeHandle maxHandle;

        // TEST 81-11
        // ハンドル数が上限を超えている状態だと失敗する
        result = nn::svc::CreateInterruptEvent(&eventHandle, name, type);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultMaxHandle());
    }

    // TEST
    // ハンドルが解放されると再度取得することが出来るようになる
    result = nn::svc::CreateInterruptEvent(&eventHandle, name, type);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(eventHandle);
    ASSERT_RESULT_SUCCESS(result);
}
#endif // ENABLE_MAX_HANDLE_TEST

TEST(CreateInterruptEvent, RegisterSameInterruptNameTest)
{
    TestInterruptEventLeak leakTest;
    nn::Result result;
    nn::svc::InterruptType type = nn::svc::InterruptType_Level;
#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
    int32_t name = TmrDefaultInterruptNumber;
#else
#error not implemented
#endif

    nn::svc::Handle handles[2];

    result = nn::svc::CreateInterruptEvent(&handles[0], name, type);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose eventCloser(handles[0]);

    result = nn::svc::CreateInterruptEvent(&handles[1], name, type);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultBusy());

}

// TEST 16-22
// 一度クリアした割り込みイベントをもう一度シグナル状態にすることが出来る
TEST(CreateInterruptEvent, MultipleInterrupts)
{
    TestInterruptEventLeak leakTest;
    nn::Result result;

#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
    nn::svc::InterruptType type = nn::svc::InterruptType_Level;
    int32_t name = TmrDefaultInterruptNumber;
    nn::svc::Handle handle;

    result = nn::svc::CreateInterruptEvent(&handle, name, type);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose eventCloser(handle);

    TestTmrDriver tmr;
    tmr.SetTimer(100);
    tmr.StartTimer();

    // TEST 21-13
    // CreateInterruptEvent の読み込みイベントを待つことが出来る
    int32_t index;
    result = nn::svc::WaitSynchronization(&index, &handle, 1, 100 * 1000 * 1000);
    ASSERT_RESULT_SUCCESS(result);

    tmr.ClearInterrupt();

    result = nn::svc::ClearEvent(handle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::WaitSynchronization(&index, &handle, 1, 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());

    tmr.StartTimer();

    result = nn::svc::WaitSynchronization(&index, &handle, 1, 100 * 1000 * 1000);
    ASSERT_RESULT_SUCCESS(result);

    tmr.ClearInterrupt();

    result = nn::svc::ClearEvent(handle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::WaitSynchronization(&index, &handle, 1, 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());
#else
#error not implemented
#endif
}
#endif // NN_BUILD_CONFIG_HARDWARE_JETSONTK1
