﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>

#ifdef ENABLE_MAX_HANDLE_TEST
TEST(CreateEventTest, MaxHandleTest)
{
    TestEventLeak leakTest;
    nn::Result result;
    nn::svc::Handle writableEvent;
    nn::svc::Handle readableEvent;

    {
        ConsumeHandle maxHandle;
        nn::svc::Handle* handles = maxHandle.GetHandles();

        // 1 つだけは空き状況を作る
        result = nn::svc::CloseHandle(handles[0]);
        ASSERT_RESULT_SUCCESS(result);
        handles[0] = nn::svc::INVALID_HANDLE_VALUE;

        // TEST 69-40
        // ハンドル数が上限に達していると、イベントを作成できない
        result = nn::svc::CreateEvent(&writableEvent, &readableEvent);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultMaxHandle());
    }

    result = nn::svc::CreateEvent(&writableEvent, &readableEvent);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(writableEvent);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(readableEvent);
    ASSERT_RESULT_SUCCESS(result);
}
#endif // ENABLE_MAX_HANDLE_TEST
