﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Dd.h>

#ifdef ENABLE_MAX_HANDLE_TEST
extern "C" void nnMain();

namespace {
const uint64_t SpaceAddr = 0;
} // namespace

TEST(CreateDeviceAddressSpace, MaxHandleTest)
{
    TestDeviceAddressSpaceLeak leakTest;
    nn::Result result;
    size_t size = 0x200000; // 2MB
    nn::svc::Handle handle;

    {
        ConsumeHandle maxHandle;

        // TEST 129-15
        // ハンドル数が上限に達している状態で呼び出すことが出来ない
        result = nn::svc::CreateDeviceAddressSpace(&handle, SpaceAddr, size);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultMaxHandle());
    }

    // TEST 129-16
    // ハンドル数が上限を下回ると、再度呼び出しが可能になる
    result = nn::svc::CreateDeviceAddressSpace(&handle, SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);
}
#endif // ENABLE_MAX_HANDLE_TEST
