﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>

namespace {

const int NumTest = 100;
const int WaitTime = 0;

/*
   シグナル状態にあるイベントをクリア後も、イベントを利用できる
 */
void ExecuteManyTimes(bool isRead)
{
    nn::Result result;
    nn::svc::Handle readHandle;
    nn::svc::Handle writeHandle;
    int32_t index;

    result = nn::svc::CreateEvent(&writeHandle, &readHandle);
    ASSERT_RESULT_SUCCESS(result);

    for (int i = 0; i < NumTest; i++)
    {
        result = nn::svc::SignalEvent(writeHandle);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::WaitSynchronization(&index, &readHandle, 1, WaitTime);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SignalEvent(writeHandle);
        ASSERT_RESULT_SUCCESS(result);

        result = (isRead) ? nn::svc::ClearEvent(readHandle)
                          : nn::svc::ClearEvent(writeHandle);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::WaitSynchronization(&index, &readHandle, 1, WaitTime);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());
    }

    result = nn::svc::CloseHandle(writeHandle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(readHandle);
    ASSERT_RESULT_SUCCESS(result);
}

} // namespace

TEST(ClearEvent, ClearEventManyTimesTest)
{
    TestEventLeak leakTest;
    // TEST 16-19
    ExecuteManyTimes(true);

    // TEST 16-20
    ExecuteManyTimes(false);
}

