﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <cstring>
#include <nn/svc/svc_Dd.h>

namespace {
const char* testString = "test";
}
extern "C" void nnMain();





TEST(InvalidateProcessDataCache, Test0)
{
    TestProcessLeak testProcessLeak;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    nn::Bit32 flags[DefaultCapabilityFlagNum];
    SetDefaultCapability(flags, DefaultCapabilityFlagNum);

    {
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = 0x00200000;
        param.memoryNumPages = 0x00000100;
        param.flags          = 0x00000000;

        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_ReadExecute);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 4 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_Read);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 8 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_ReadWrite);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 83-23
        // RE
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 0 * 0x1000, 0x10);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        // TEST 83-24
        // R
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 4 * 0x1000, 0x10);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        // TEST 83-25
        // RW
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 83-26
        // 書き込み領域のある領域内であれば、ブロックの最初でなくても成功する
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0x10, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 83-27
        // ページ境界をまたぐ領域でも成功する
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x20);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x1010);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x1020);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 83-29
        // 領域の終端条件の確認
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 12 * 0x1000 - 0x10, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 83-30
        // メモリ状態が一様でないと失敗する (前方)
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 - 0x10, 0x20);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        // TEST 83-31
        // メモリ状態が一様でないと失敗する (後方)
        result = nn::svc::InvalidateProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 12 * 0x1000 - 0x10, 0x20);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
}
TEST(InvalidateProcessDataCache, Test1)
{
    nn::Result result;
    nn::svc::Handle handle(0xFFFF8001);

    uintptr_t addr;
    size_t size = HeapAlign;
    result = nn::svc::SetHeapSize(&addr, size);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 83-4
    // RE
    result = nn::svc::InvalidateProcessDataCache(handle, reinterpret_cast<uintptr_t>(&nnMain), 0x10);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

    // TEST 83-3
    // R
    result = nn::svc::InvalidateProcessDataCache(handle, reinterpret_cast<uintptr_t>(testString), 0x10);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

    // TEST 83-1
    // RW
    result = nn::svc::InvalidateProcessDataCache(handle, reinterpret_cast<uintptr_t>(&addr), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::InvalidateProcessDataCache(handle, reinterpret_cast<uintptr_t>(addr), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);
}

TEST(StoreProcessDataCache, Test0)
{
    TestProcessLeak testProcessLeak;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    nn::Bit32 flags[DefaultCapabilityFlagNum];
    SetDefaultCapability(flags, DefaultCapabilityFlagNum);

    {
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = 0x00200000;
        param.memoryNumPages = 0x00000100;
        param.flags          = 0x00000000;

        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_ReadExecute);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 4 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_Read);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 8 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_ReadWrite);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 84-25
        // RE
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 0 * 0x1000, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 84-26
        // R
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 4 * 0x1000, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 84-27
        // RW
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 84-28
        // 書き込み領域のある領域内であれば、ブロックの最初でなくても成功する
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0x10, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 84-29
        // ページ境界をまたぐ領域でも成功する
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x20);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x1010);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x1020);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 84-30
        // 領域の終端条件の確認
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 12 * 0x1000 - 0x10, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 84-31
        // メモリ状態が一様でないと失敗する (前方)
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 - 0x10, 0x20);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        // TEST 84-32
        // メモリ状態が一様でないと失敗する (後方)
        result = nn::svc::StoreProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 12 * 0x1000 - 0x10, 0x20);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
}
TEST(StoreProcessDataCache, Test1)
{
    uintptr_t addr;
    size_t size;
    nn::Result result;
    nn::svc::Handle handle(0xFFFF8001);

    size = HeapAlign;
    result = nn::svc::SetHeapSize(&addr, size);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 84-4
    // MemoryPermission_ReadExecute の領域を指し示していると成功する
    result = nn::svc::StoreProcessDataCache(handle, reinterpret_cast<uintptr_t>(&nnMain), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 84-3
    // MemoryPermission_Read の領域を指し示していると成功する
    result = nn::svc::StoreProcessDataCache(handle, reinterpret_cast<uintptr_t>(testString), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 84-1
    // MemoryPermission_ReadWrite の領域を指し示していると成功する
    result = nn::svc::StoreProcessDataCache(handle, reinterpret_cast<uintptr_t>(&addr), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::StoreProcessDataCache(handle, reinterpret_cast<uintptr_t>(addr), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 84-37
    // 0x1000 を addr に与えると失敗する
    result = nn::svc::StoreProcessDataCache(handle, 0x1000, 0x10);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);
}

TEST(FlushProcessDataCache, Test0)
{
    TestProcessLeak testProcessLeak;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    nn::Bit32 flags[DefaultCapabilityFlagNum];
    SetDefaultCapability(flags, DefaultCapabilityFlagNum);

    {
        std::strncpy(param.name, "test", sizeof(param.name));
        param.version        = 0xbabeface;
        param.programId      = 0xdeadbeef0badcafeull;
        param.memoryAddress  = 0x00200000;
        param.memoryNumPages = 0x00000100;
        param.flags          = 0x00000000;

        result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 0 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_ReadExecute);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 4 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_Read);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress + 8 * 0x1000, 4 * 0x1000, nn::svc::MemoryPermission_ReadWrite);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 85-25
        // RE
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 0 * 0x1000, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 85-26
        // R
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 4 * 0x1000, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 85-1
        // RW
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 85-28
        // 書き込み領域のある領域内であれば、ブロックの最初でなくても成功する
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0x10, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 85-29
        // ページ境界をまたぐ領域でも成功する
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x20);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x1010);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 + 0xff0, 0x1020);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 85-30
        // 領域の終端条件の確認
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 12 * 0x1000 - 0x10, 0x10);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 85-31
        // メモリ状態が一様でないと失敗する (前方)
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 8 * 0x1000 - 0x10, 0x20);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        // TEST 85-32
        // メモリ状態が一様でないと失敗する (後方)
        result = nn::svc::FlushProcessDataCache(static_cast<nn::svc::Handle>(handle),  param.memoryAddress + 12 * 0x1000 - 0x10, 0x20);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
}
TEST(FlushProcessDataCache, Test1)
{
    uintptr_t addr;
    size_t size;
    nn::Result result;
    nn::svc::Handle handle(0xFFFF8001);

    size = HeapAlign;
    result = nn::svc::SetHeapSize(&addr, size);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 85-4
    // RE
    result = nn::svc::FlushProcessDataCache(handle, reinterpret_cast<uintptr_t>(&nnMain), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 85-3
    // R
    result = nn::svc::FlushProcessDataCache(handle, reinterpret_cast<uintptr_t>(testString), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 85-1
    // RW
    result = nn::svc::FlushProcessDataCache(handle, reinterpret_cast<uintptr_t>(&addr), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::FlushProcessDataCache(handle, reinterpret_cast<uintptr_t>(addr), 0x10);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 85-37
    // addr に 0x1000 を与えると失敗する
    result = nn::svc::FlushProcessDataCache(handle, 0x1000, 0x10);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);
}


