﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_TestSdmmc.h"
#include <nn/svc/svc_Dd.h>

namespace {
#if defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined (NN_BUILD_CONFIG_HARDWARE_NX) || defined (SUPPORT_SDCARD_TEST)
const uint64_t SpaceAddr = 0x0;
#endif

} // namespace

#if defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined (NN_BUILD_CONFIG_HARDWARE_NX)
// TEST 130-9
// 34bit テーブルを必要とするデバイスに34ビット未満のサイズのテーブルを持つアドレスう空間のハンドルを渡すと失敗する
TEST(AttachDeviceAddressSpace, 34BitTableTest)
{
    TestDeviceAddressSpaceLeak leakTest;
    nn::Result result;
    uint64_t size = 0x400000000;
    nn::svc::Handle handle;

    result = nn::svc::CreateDeviceAddressSpace(&handle, SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose addressCloser(handle);

    for (int32_t i = 0; i < nn::svc::DeviceName_Num; i++)
    {
        nn::svc::DeviceName name = static_cast<nn::svc::DeviceName>(i);
        result = nn::svc::AttachDeviceAddressSpace(name, handle);
        switch(name)
        {
            // 常に disable のデバイス
            case nn::svc::DeviceName_Gpu:
            case nn::svc::DeviceName_Tsec1:
            case nn::svc::DeviceName_Tsecb1:
                ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());
            case nn::svc::DeviceName_Nv:
            case nn::svc::DeviceName_Nv2:
            case nn::svc::DeviceName_Nvdec1:
                ASSERT_TRUE(result <= nn::svc::ResultNotFound() ||
                        result <= nn::svc::ResultInvalidCombination());
                continue;
                // 34 bit テーブルに対応していないデバイス
            case nn::svc::DeviceName_Avpc:
            case nn::svc::DeviceName_Hc:
            case nn::svc::DeviceName_Nvenc:
            case nn::svc::DeviceName_Ppcs:
            case nn::svc::DeviceName_Vic:
            case nn::svc::DeviceName_Ppcs1:
            case nn::svc::DeviceName_Ppcs2:
            case nn::svc::DeviceName_Nvdec:
            case nn::svc::DeviceName_Ape:
            case nn::svc::DeviceName_Se:
            case nn::svc::DeviceName_Nvjpg:
            case nn::svc::DeviceName_Hc1:
            case nn::svc::DeviceName_Se1:
                ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCombination());
                continue;
            default:
                break;
        }
        ASSERT_TRUE(result.IsSuccess() || result <= nn::svc::ResultBusy());

        if (result.IsSuccess())
        {
            result = nn::svc::DetachDeviceAddressSpace(name, handle);
            ASSERT_RESULT_SUCCESS(result);
        }
    }
}
#endif // defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined (NN_BUILD_CONFIG_HARDWARE_NX)

#ifdef SUPPORT_SDCARD_TEST
// TEST 130-11
// １つのデバイスに複数のアドレススペースをアタッチすることは出来ない
TEST(AttachDeviceAddressSpace, MultipleAttachTest)
{
    TestDeviceAddressSpaceLeak leakTest;
    nn::Result result;
    uint64_t size = 0x40000000;
    nn::svc::Handle handles[2];

    result = nn::svc::CreateDeviceAddressSpace(&handles[0], SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose addressCloser1(handles[0]);

    result = nn::svc::CreateDeviceAddressSpace(&handles[1], SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose addressCloser3(handles[1]);

    result = nn::svc::AttachDeviceAddressSpace(DeviceName_SdCard, handles[0]);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::AttachDeviceAddressSpace(DeviceName_SdCard, handles[1]);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultBusy());
}
#endif // SUPPORT_SDCARD_TEST

