﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/os.h>

extern "C" void nnMain();

namespace {

const int64_t SleepTime = 100 * 1000 * 1000;
volatile nn::Bit32 g_Lock[2];
char g_Stack[2][DefaultStackSize] __attribute__((aligned(0x1000)));
int32_t g_Sequence;

struct TestData
{
    nn::svc::Handle handle;
    uintptr_t addr;
    int32_t id;
};

void LockThread(uintptr_t arg)
{
    AutoThreadExit autoExit;
    nn::Result result;
    TestData* testData = reinterpret_cast<TestData*>(arg);

    result = nn::svc::ArbitrateLock(testData->handle, testData->addr, 0);
    ASSERT_RESULT_SUCCESS(result);

    g_Sequence = testData->id;
}

} // namespace

TEST(ArbitrateUnlock, NotRelatedThreadTest)
{
    nn::Result result;

    TestData testData[2];
    testData[0].handle = nn::svc::Handle(nn::os::GetCurrentThread()->_handle);
    testData[0].addr = reinterpret_cast<uintptr_t>(&g_Lock[0]);
    testData[0].id = 1;
    testData[1].handle = testData[0].handle;
    testData[1].addr = reinterpret_cast<uintptr_t>(&g_Lock[1]);
    testData[1].id = 2;

    nn::Bit32 value = static_cast<nnHandle>(testData[0].handle).value
        | nn::svc::Handle::WaitMask;
    g_Lock[0] = value;
    g_Lock[1] = value;

    uintptr_t pc = reinterpret_cast<uintptr_t>(LockThread);
    uintptr_t sp = reinterpret_cast<uintptr_t>(g_Stack[0]) + sizeof(g_Stack[0]);
    uintptr_t param = reinterpret_cast<uintptr_t>(&testData[0]);
    int32_t priority = TestLowestThreadPriority;
    int32_t idealCore = nn::svc::IdealCoreUseProcessValue;

    g_Sequence = 0;
    TestThread lowerThread(pc, param, sp, priority, idealCore);
    lowerThread.Start();

    sp = reinterpret_cast<uintptr_t>(g_Stack[1]) + sizeof(g_Stack[1]);
    param = reinterpret_cast<uintptr_t>(&testData[1]);

    priority = TestLowestThreadPriority - 1;
    TestThread higherThread(pc, param, sp, priority, idealCore);
    higherThread.Start();

    // 作ったスレッドがロック待ちするのを待つ
    nn::svc::SleepThread(SleepTime);

    // 低優先度側だけ起こす
    result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Lock[0]));
    ASSERT_RESULT_SUCCESS(result);

    nn::svc::SleepThread(SleepTime);

    ASSERT_TRUE(g_Sequence == testData[0].id);
    ASSERT_TRUE(g_Lock[0] == 0);
    ASSERT_TRUE(g_Lock[1] == value);

    result = nn::svc::ArbitrateUnlock(reinterpret_cast<uintptr_t>(&g_Lock[1]));
    ASSERT_RESULT_SUCCESS(result);

    lowerThread.Wait();
    higherThread.Wait();
}

