﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "sdmmc_Common.h"

namespace nn { namespace sdmmc1 {

    const size_t SdCardScrSize = 8;
    const size_t SdCardSwitchFunctionStatusSize = 64;
    const size_t SdCardSdStatusSize = 64;
    const size_t SdCardWorkBufferSize = 64;     // 上記の最大値

    enum SdCardSwitchFunction
    {
        SdCardSwitchFunction_CheckSupportedFunction,
        SdCardSwitchFunction_CheckDefault,
        SdCardSwitchFunction_CheckHighSpeed,
        SdCardSwitchFunction_CheckSdr50,
        SdCardSwitchFunction_CheckSdr104,
        SdCardSwitchFunction_CheckDdr50
    };

    Result ActivateSdCard(Port port, void* pSdCardWorkBuffer, size_t sdCardWorkBufferSize) NN_NOEXCEPT;
    Result GetSdCardSpeedMode(SpeedMode* pOutSpeedMode, Port port, void* pSdCardWorkBuffer, size_t sdCardWorkBufferSize) NN_NOEXCEPT;
    Result GetSdCardProtectedAreaCapacity(uint32_t* pOutNumSectors, Port port, void* pSdCardWorkBuffer, size_t sdCardWorkBufferSize) NN_NOEXCEPT;
    Result GetSdCardScr(void* pOutScrBuffer, size_t scrBufferSize, Port port) NN_NOEXCEPT;
    Result GetSdCardSwitchFunctionStatus(void* pOutSwitchFunctionStatusBuffer, size_t switchFunctionStatusBufferSize,
        Port port, SdCardSwitchFunction sdCardSwitchFunction) NN_NOEXCEPT;
    Result GetSdCardSdStatus(void* pOutSdStatusBuffer, size_t sdStatusBufferSize, Port port) NN_NOEXCEPT;
    bool IsSdCardInserted(Port port) NN_NOEXCEPT;
    void RegisterSdCardDetectionEventCallback(Port port, DeviceDetectionEventCallback callback, void* pParameter) NN_NOEXCEPT;
    void UnregisterSdCardDetectionEventCallback(Port port) NN_NOEXCEPT;

}} // namespace nn { namespace sdmmc1 {
