﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#if (defined(NN_DETAIL_SDMMC_USE_NN_LOG_FOR_LOG))
    #include <nn/log.h>
    #define NN_DETAIL_SDMMC_LOG                     NN_LOG
#else
    #include <nn/nn_SdkLog.h>
    #define NN_DETAIL_SDMMC_LOG                     NN_SDK_LOG
#endif

namespace nn { namespace sdmmc1 {
namespace detail {

void LogData(void* pData, size_t dataSize) NN_NOEXCEPT;

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {


// コマンド通信ログ出力 (1: 有効, 0: 無効)
#if 0
#define NN_DETAIL_SDMMC_CMD_LOG(fmt, ...)           NN_DETAIL_SDMMC_LOG("[sdmmc] " fmt, ##__VA_ARGS__)
#else
#define NN_DETAIL_SDMMC_CMD_LOG(...)                static_cast<void>(0)
#endif

// データログ出力 (1: 有効, 0: 無効)
#if 0
#define NN_DETAIL_SDMMC_DATA_LOG(pData, dataSize)   nn::sdmmc1::detail::LogData(pData, dataSize)
#else
#define NN_DETAIL_SDMMC_DATA_LOG(pData, dataSize)
#endif

// エラー検出ログ出力 (1: 有効, 0: 無効)
#if 0
#define NN_DETAIL_SDMMC_ERROR_LOG(fmt, ...)         NN_DETAIL_SDMMC_LOG("[sdmmc] %s:%d " fmt, __FILE__, __LINE__, ##__VA_ARGS__)
#else
#define NN_DETAIL_SDMMC_ERROR_LOG(...)              static_cast<void>(0)
#endif

// デバッグ用ログ出力 (1: 有効, 0: 無効)
#if 0
#define NN_DETAIL_SDMMC_DEBUG_LOG(fmt, ...)         NN_DETAIL_SDMMC_LOG("[sdmmc] " fmt, ##__VA_ARGS__)
#else
#define NN_DETAIL_SDMMC_DEBUG_LOG(...)              static_cast<void>(0)
#endif

// 挿抜検出ログ出力 (1: 有効, 0: 無効)
#if 0
#define NN_DETAIL_SDMMC_DETECTOR_LOG(fmt, ...)      NN_DETAIL_SDMMC_LOG("[sdmmc] " fmt, ##__VA_ARGS__)
#else
#define NN_DETAIL_SDMMC_DETECTOR_LOG(...)           static_cast<void>(0)
#endif
