﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace i2c {
namespace driver {
namespace detail {

// デバイス設定情報を格納した構造体
const DeviceSetting DeviceSettings[] =
{
    // I2C1 に接続されたクラコン
    {
        nn::i2c::I2cDevice::I2cDevice_Name,  // Device name
        0,                                   // Bus#
        0x52,                                // Slave address
        AddressingMode_BitWidth7,            // Addressing mode
        SpeedMode_Fast                       // Speed mode
    },
    // Power management unit - Pmic
    {
        nn::i2c::I2cDevice::I2cDevice_Max77620Pmic,
        4,
        0x3c,
        AddressingMode_BitWidth7,
        SpeedMode_Fast
    },
    // ここにデバイスを追記してください。
};

const int DeviceSettingsLength = (sizeof(DeviceSettings) / sizeof(DeviceSettings[0]));

const int MaxBuses             = 6;         // [Ref1] 31.0 物理的なバス数は6つ
const int MaxSessions          = 20;        // 論理的な通信チャネルの最大値

} // detail
} // driver
} // i2c
} // nn
