﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../../include/nn/i2c/driver/i2c.h"
#include <nn/os/os_Mutex.h>

#include "i2c_BusAccessor.h"
#include "i2c_Command.h"


namespace nn {
namespace i2c {
namespace driver {
namespace detail {

class Session
{
    NN_DISALLOW_COPY(Session);
    NN_DISALLOW_MOVE(Session);

public:
    Session() NN_NOEXCEPT :
        m_IsOpen(false),                               // クローズ状態
        m_pBusAccessor(nullptr),                       // バスアクセッサは未登録
        m_SlaveAddress(0x0000),                        // スレーブアドレスはゼロ埋め
        m_AddressingMode(AddressingMode_BitWidth7),    // 7 bit addressing mode
        m_BusAccessorMutex(false)                      // セッションのステート向けの Mutex
        {}

    void      Open( int busIdx, Bit16 slaveAddress, AddressingMode addressingMode, SpeedMode speedMode, BusAccessor* pBusAccessor ) NN_NOEXCEPT; // Session を開始するときに呼ばれる。引数　device は m_I2cDevice に格納する
    void      Close() NN_NOEXCEPT;                  // Session を終了するときに呼ばれる。

    bool      IsOpened() const NN_NOEXCEPT;         // セッションの状態 m_IsOpen を返す

    Result    ExecuteTransaction( void* pReceiveData, const void* pSendData, size_t dataBytes, TransactionOption inOption, Command command ) NN_NOEXCEPT;

private:
    bool                        m_IsOpen;                  // セッションのステート。排他が必要
    BusAccessor*                m_pBusAccessor;            // 各Busのアクセッサへのポインタ。Open時に登録される。
    Bit16                       m_SlaveAddress;            // スレーブアドレス
    AddressingMode              m_AddressingMode;          // アドレスモード
    nn::os::Mutex               m_BusAccessorMutex;        // ロック対象は m_pBusAccessor
};

} // detail
} // driver
} // i2c
} // nn
