﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Threading;
using Nintendo.Log;


namespace Nintendo.StressTest
{
    public class Program
    {
        public const string BINARY_FILE_EXT = "nxbinlog";
        public const string TEXT_FILE_EXT = "log";
        public const int CONVERT_BINARY_FILE_TIMEOUT_MS = 10000;

        public static void Main(string[] args)
        {
            // input parameter should be
            //    - full path to directory where *.nxbinlog files reside  (eg. C:\Temp)

            if (args.Length == 0)
            {
                Console.Error.WriteLine("Please enter parameter:  full path to directory of *.nxbinlog files");
                System.Environment.Exit(1);
            }

            // get the directory
            string inDir = args[0];

            foreach (string inFilePath in Directory.EnumerateFiles(inDir, "*." + BINARY_FILE_EXT))
            {
                try
                {
                    string outFilePath = inFilePath + "." + TEXT_FILE_EXT;
                    var cs = new CancellationTokenSource();

                    // convert binary file to text file
                    System.Threading.Tasks.Task task = LogClient.CreateNxbinlogToTextTask(outFilePath, inFilePath, cs.Token, null);

                    task.Start();
                    task.Wait(CONVERT_BINARY_FILE_TIMEOUT_MS);
                }
                catch (Exception exception)
                {
                    PrintException(exception);
                    System.Environment.Exit(1);
                }
            }
        }

        public static void PrintException(Exception exception)
        {
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Console.WriteLine(string.Format("StackTrace: {0}", exception.StackTrace));
        }
    }
}
