﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/spy/spy_LogModule.h>

extern bool g_ExecuteTest;

TEST(IncludeTest, spy_LogModule_h)
{
    if (g_ExecuteTest)
    {
        (void)nn::spy::LogModule::MaxMessageLength;

        nn::spy::SpyController* pController = NULL;
        nn::spy::LogModule module;
#if defined(NN_BUILD_CONFIG_COMPILER_CLANG)
        va_list argList;
#else
        va_list argList = NULL;
#endif
        int i = 0;
        long l = 0;
        float f = 0;
        double d = 0;
        char c = 0;
        char s0[] = "char*";
        const char* s1 = "const char*";

        nn::spy::LogModule::Write(*pController, "message");

        nn::spy::LogModule::WriteFormat(*pController, "format");
        nn::spy::LogModule::WriteFormat(*pController, "format");
        nn::spy::LogModule::WriteFormat(*pController, "format", i);
        nn::spy::LogModule::WriteFormat(*pController, "format", &i);
        nn::spy::LogModule::WriteFormat(*pController, "format", l);
        nn::spy::LogModule::WriteFormat(*pController, "format", f);
        nn::spy::LogModule::WriteFormat(*pController, "format", d);
        nn::spy::LogModule::WriteFormat(*pController, "format", c);
        nn::spy::LogModule::WriteFormat(*pController, "format", s0);
        nn::spy::LogModule::WriteFormat(*pController, "format", s1);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, l, f, d, c, s0, s1);
        // 隣合う引数が同じ型になっていないかもチェック。
        nn::spy::LogModule::WriteFormat(*pController, "format", i);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i, d);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i, d, i);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i, d, i, d);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i, d, i, d, i);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i, d, i, d, i, d);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i, d, i, d, i, d, i);
        nn::spy::LogModule::WriteFormat(*pController, "format", i, d, i, d, i, d, i, d, i, d);

        nn::spy::LogModule::WriteFormatV(*pController, "format", argList);

        module.Write("message");

        module.WriteFormat("format");
        module.WriteFormat("format", i);
        module.WriteFormat("format", &i);
        module.WriteFormat("format", l);
        module.WriteFormat("format", f);
        module.WriteFormat("format", d);
        module.WriteFormat("format", s0);
        module.WriteFormat("format", s1);
        module.WriteFormat("format", s1[0]);
        module.WriteFormat("format", i, l, f, d, c, s0, s1);
        // 隣合う引数が同じ型になっていないかもチェック。
        module.WriteFormat("format", i);
        module.WriteFormat("format", i, d);
        module.WriteFormat("format", i, d, i);
        module.WriteFormat("format", i, d, i, d);
        module.WriteFormat("format", i, d, i, d, i);
        module.WriteFormat("format", i, d, i, d, i, d);
        module.WriteFormat("format", i, d, i, d, i, d, i);
        module.WriteFormat("format", i, d, i, d, i, d, i, d);
        module.WriteFormat("format", i, d, i, d, i, d, i, d, i);
        module.WriteFormat("format", i, d, i, d, i, d, i, d, i, d);

        module.WriteFormatV("format", argList);
    }

    EXPECT_TRUE(true);
}
