﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nnt.h>
#include <nn/nn_Log.h>

#include <nn/spy.h>

#include <nn/spy/detail/spy_PacketUtility.h>

#if defined(NN_BUILD_CONFIG_SPY_ENABLED)

TEST(PacketUtility, Basic)
{
#if defined(NN_BUILD_CONFIG_ADDRESS_64)
    {
        nn::spy::detail::IdData idData;
        idData.Set(reinterpret_cast<void*>(0x0123456789abcdef));

#if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
        EXPECT_EQ(idData.data[0], 0x89abcdef);
        EXPECT_EQ(idData.data[1], 0x01234567);
#endif

#if defined(NN_BUILD_CONFIG_ENDIAN_BIG)
        EXPECT_EQ(idData.data[0], 0x01234567);
        EXPECT_EQ(idData.data[1], 0x89abcdef);
#endif
    }
#endif

#if defined(NN_BUILD_CONFIG_ADDRESS_32)
    {
        nn::spy::detail::IdData idData;
        idData.Set(reinterpret_cast<void*>(0x01234567));

#if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
        EXPECT_EQ(idData.data[0], 0x01234567);
        EXPECT_EQ(idData.data[1], 0x0);
#endif

#if defined(NN_BUILD_CONFIG_ENDIAN_BIG)
        EXPECT_EQ(idData.data[0], 0x0);
        EXPECT_EQ(idData.data[1], 0x01234567);
#endif
    }
#endif

    {
        nn::spy::detail::DoubleData doubleData;

        double f1 = 1234.5;
        doubleData.Set(f1);

#if defined(NN_BUILD_CONFIG_ENDIAN_LITTLE)
        uint64_t n = doubleData.data[0] | static_cast<uint64_t>(doubleData.data[1]) << 32;
        double f2 = nn::spy::detail::fnd::Uint64AsDouble(n);
        EXPECT_EQ(f1, f2);
#endif

#if defined(NN_BUILD_CONFIG_ENDIAN_BIG)
        uint64_t n = doubleData.data[1] | static_cast<uint64_t>(doubleData.data[0]) << 32;
        double f2 = nn::spy::detail::fnd::Uint64AsDouble(n);
        EXPECT_EQ(f1, f2);
#endif
    }
}

#endif
