﻿namespace ToolVersionUpdater.Views
{
    using Microsoft.Win32;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using System.Windows.Shapes;

    /// <summary>
    /// ElementStringUITypeView.xaml の相互作用ロジック
    /// </summary>
    public partial class ElementPathUITypeView : UserControl
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ElementPathUITypeView()
        {
            this.InitializeComponent();
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            var dialog = new OpenFileDialog();
            dialog.Title = "ファイルを開く";
            var dataModel = this.DataContext as ParamString;
            if (!string.IsNullOrEmpty(dataModel.UIParam))
            {
                dialog.Filter = dataModel.UIParam;
            }
            else
            {
                dialog.Filter = "すべてのファイル(*.*)|*.*";
            }
            if (dialog.ShowDialog() == true)
            {
                (this.DataContext as ParamString).Value.Value = dialog.FileName;
            }
        }
    }
}
