﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ToolVersionUpdater
{
    public class Utility
    {
        private static string EncodeStringToDefault(string log, Encoding sourceEncoding)
        {
            byte[] logBytes = sourceEncoding.GetBytes(log);
            byte[] encodedBytes = Encoding.Convert(sourceEncoding, Encoding.Default, logBytes);
            string encodedLog = Encoding.Default.GetString(encodedBytes);
            return encodedLog;
        }

        public static bool HasSubstrings(string targetString, IEnumerable<string> substrings)
        {
            foreach (var substring in substrings)
            {
                if (!string.IsNullOrEmpty(substring) && targetString.Contains(substring))
                {
                    return true;
                }
            }

            return false;
        }
        public static void ExecuteCommand(
            out string standardOut,
            out string standardError,
            string command,
            string args,
            Encoding outputEncoding)
        {
            ExecuteCommand(
                out standardOut, out standardError,
                command, args, System.IO.Directory.GetCurrentDirectory(), outputEncoding);
        }
        public static void ExecuteCommand(
            string command,
            string args,
            string workingDirectory)
        {
            ExecuteCommand(
                command, args, workingDirectory, Encoding.Default);
        }

        public static void ExecuteCommand(
            out string standardOut,
            out string standardError,
            string command,
            string args,
            string workingDirectory,
            Encoding outputEncoding)
        {
            System.Diagnostics.Process process = new System.Diagnostics.Process();
            process.StartInfo.FileName = command;
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.RedirectStandardInput = false;
            process.StartInfo.CreateNoWindow = true;
            process.StartInfo.Arguments = args;
            process.StartInfo.WorkingDirectory = workingDirectory;
            process.StartInfo.StandardOutputEncoding = outputEncoding;
            process.StartInfo.StandardErrorEncoding = outputEncoding;

            Console.WriteLine(command + " " + args + "\n");
            process.Start();

            //出力を読み取る
            string tempStandardOut = process.StandardOutput.ReadToEnd();
            string tempStandardError = process.StandardError.ReadToEnd();
            process.WaitForExit();

            process.Close();

            standardOut = EncodeStringToDefault(tempStandardOut, outputEncoding);
            standardError = EncodeStringToDefault(tempStandardError, outputEncoding);
        }

        public static void ExecuteCommand(
            string command,
            string args,
            string workingDirectory,
            Encoding outputEncoding)
        {
            System.Diagnostics.Process process = new System.Diagnostics.Process();
            process.StartInfo.FileName = command;
            process.StartInfo.UseShellExecute = true;
            process.StartInfo.RedirectStandardOutput = false;
            process.StartInfo.RedirectStandardError = false;
            process.StartInfo.RedirectStandardInput = false;
            process.StartInfo.CreateNoWindow = false;
            process.StartInfo.Arguments = args;
            process.StartInfo.WorkingDirectory = workingDirectory;

            process.Start();
            process.WaitForExit();
            process.Close();
        }

        public static void ExecuteCommand(
            string command,
            string args,
            Encoding outputEncoding,
            System.Diagnostics.DataReceivedEventHandler outputReceived)
        {
            System.Diagnostics.Process process = new System.Diagnostics.Process();
            process.StartInfo.FileName = command;
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.CreateNoWindow = true;
            process.StartInfo.Arguments = args;
            process.OutputDataReceived += outputReceived;
            process.ErrorDataReceived += outputReceived;
            process.Start();

            process.BeginOutputReadLine();
            process.BeginErrorReadLine();
        }
    }
}
