﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ToolVersionChecker
{
    public class ToolVersion
    {
        public ToolVersion(int major, int minor, int micro)
        {
            this.MajorVersion = major;
            this.MinorVersion = minor;
            this.MicroVersion = micro;
            this.IsValid = true;
        }

        public bool IsValid { get; set; } = false;

        public int MajorVersion { get; set; }

        public int MinorVersion { get; set; }

        public int MicroVersion { get; set; }

        public override string ToString()
        {
            return $"{this.MajorVersion}.{this.MinorVersion}.{this.MicroVersion}";
        }

        static public ToolVersion InvalidVersion = new ToolVersion(-1, -1, -1) { IsValid = false };
    }
}
