﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Linq;
using System.IO;
using Nintendo.NintendoSdkVsExtension.Base;

namespace Nintendo.NintendoSdkVsExtension.UnitTest
{
    [TestClass]
    public class SdkInformationTest
    {
        public TestContext TestContext { get; set; }

        [TestMethod]
        [ExpectedException(typeof(InvalidSdkRootException))]
        public void TestInvalidSdkRoot()
        {
            var sdkInfo = new SdkInformation(
                Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location));
        }

        [TestMethod]
        public void TestSdkSpecs()
        {
            var testPath = new TestUtility.TestPath(TestContext);
            var sdkRoot = testPath.GetSigloRoot();
            var sdkInfo = new SdkInformation(sdkRoot);

            var expectedSpecs = new string[] { "Generic", "Cafe", "NX" };

            CollectionAssert.AreEquivalent(sdkInfo.Specs.ToArray(), expectedSpecs);
        }

        // [TestMethod]
        // public void TestSdkVersion()
    }
}
