﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.Shell.Interop;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Microsoft.VSSDK.Tools.VsIdeTesting;
using Nintendo.NintendoSdkVsExtension.Shell;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.UnitTest.ShellTest
{
    [TestClass]
    [DeploymentItem(InIdeTestConstants.VsVersionSpecificTestDataSourceDirectory + @"Project.Generic", @"Data\Project.Generic")]
    public class VsSolutionUtilTest
    {
        public TestContext TestContext { get; set; }

        [TestInitialize]
        public void TestInitialize()
        {
            VsTestUtil.EnsureOpenSolution(@"Data\Project.Generic\Projects.sln");
        }

        [TestMethod]
        [HostType("VS IDE")]
        public void TestSolutionHasVcxproj()
        {
            // TODO: Vcxproj がない場合のテスト
            Assert.IsTrue(VsSolutionUtil.SolutionHasVcxproj(VsIdeTestHostContext.ServiceProvider));
        }

        [TestMethod]
        [HostType("VS IDE")]
        public void TestEnumerateVcxproj()
        {
            var projects = VsSolutionUtil.EnumerateVcxproj(VsIdeTestHostContext.ServiceProvider);

            var expected = new string[]
            {
                Path.GetFullPath(@"Data\Project.Generic\Project\Project.vcxproj"),
                Path.GetFullPath(@"Data\Project.Generic\Project2\Project2.vcxproj"),
            };
            CollectionAssert.AreEquivalent(
                expected,
                projects.Select(x => VsHierarchyUtil.GetProjectPath(x)).ToArray());
        }
    }
}
