﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TestAppSimple_SceneCommon.h"

class SaveDataScene : public SceneCommon
{
    NN_DISALLOW_COPY(SaveDataScene);

public:
    SaveDataScene() NN_NOEXCEPT;
    virtual ~SaveDataScene() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void EnterScene() NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    enum class State
    {
        None,
        Ensure,
        Create,
        Read,
        Update,
        Delete,
    };

    struct UserInfo
    {
        nn::account::Uid id;
        std::string name;
        int index;
        RangePackage saveButton;
        RangePackage deleteButton;
        enum class SaveState
        {
            None,
            Ensured,
            Created,
            NotSpecifiedSize,
        } saveState;
    };

private:
    const float ListPosX = 40.0f;
    const float ListPosY = 110.0f;
    const float ListSpanY = 68.0f;

private:
    void UpdateUserInfo() NN_NOEXCEPT;

private:
    State m_State;

    std::vector<UserInfo> m_UserInfoList;
    int m_CurrentIndex;

    nn::Result m_Result;
    std::string m_ActionStr;
    std::string m_LastResultStr;
};
