﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/oe.h>

#include "TestAppSimple_SceneCommon.h"

class OperationEnvScene : public SceneCommon
{
    NN_DISALLOW_COPY(OperationEnvScene);

public:
    OperationEnvScene() NN_NOEXCEPT;
    virtual ~OperationEnvScene() NN_NOEXCEPT NN_OVERRIDE {}

public:
    void SetOperationModeValue(nn::oe::OperationMode inMode) NN_NOEXCEPT;
    void SetPerformanceModeValue(nn::oe::PerformanceMode inMode) NN_NOEXCEPT;
    void SetFocusStateValue(nn::oe::FocusState inState) NN_NOEXCEPT;
    void OperateFocusHandling(nn::oe::FocusHandlingMode inSetMode) NN_NOEXCEPT;

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    void GetStaticInformation() NN_NOEXCEPT;
    void SwitchFocusHandlingMode() NN_NOEXCEPT;

    void ShowLauchParam(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
private:
    enum State
    {
        State_None,
        State_SwitchingFocusHandling,
        State_ExitInStoreDemoReady,
        State_ExitInStoreDemo,
        State_ShowLaunchParameter,
    };

    State m_State;

    std::string m_DesiredLanguage;
    std::string m_DisplayVersion;

    std::string m_OperationMode;
    std::string m_PerformanceMode;
    std::string m_FocusState;

    nn::oe::FocusHandlingMode m_CurrentFocusHandlingModeValue;
    std::string m_FocusHandlingMode;

    std::string m_InStoreDemoMode;

    WarningView m_WarningView;

    // 起動パラメータバッファ
    char m_ParamBuf[4096];

    // 起動パラメータ実サイズ
    size_t m_RealParamSize;

    // 起動パラメータ所持フラグ
    bool m_IsExistedParam;

    // 起動パラメータ表示開始行(スクロール用)
    int m_DisplayTopLineNum;

private:
    SceneCommon::RangePackage m_FocusHandlingSwitchRange;
    SceneCommon::RangePackage m_ExitInStoreDemoRange;
    SceneCommon::RangePackage m_ShowLaunchParamRange;
    SceneCommon::RangePackage m_HideLaunchParamRange;
    SceneCommon::RangePackage m_ScrollDownLaunchParamRange;
    SceneCommon::RangePackage m_ScrollUpLaunchParamRange;
};
