﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "TestAppSimple_SceneCommon.h"

class NetworkScene : public SceneCommon
{
    NN_DISALLOW_COPY(NetworkScene);

public:
    NetworkScene() NN_NOEXCEPT;
    virtual ~NetworkScene() NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    void DoNetworkRequest() NN_NOEXCEPT;
    void UpdateIsNetworkAvailable() NN_NOEXCEPT;

private:
    enum State
    {
        State_None,
        State_ProcessRequest,
    };
    enum NetworkStatus
    {
        NetworkStatus_NotAvailable,
        NetworkStatus_Verifying,
        NetworkStatus_Available,
    };

    State m_State;
    NetworkStatus m_NetworkStatus;
    nn::os::Tick m_LastUpdateTick;

    SceneCommon::RangePackage m_NetworkRequestRange;
};
