﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TestAppSimple_SceneCommon.h"

class MiiScene : public SceneCommon
{
    NN_DISALLOW_COPY(MiiScene);

public:
    MiiScene() NN_NOEXCEPT;
    virtual ~MiiScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    enum State
    {
        State_None,
        State_Launching,
    };

    enum LaunchType
    {
        LaunchType_None,
        LaunchType_AppendMii,
    };

    State m_State;
    LaunchType m_SelectedLauchType;

    struct LaunchRange
    {
        SceneCommon::RangePackage range;
        LaunchType type;
    };

    // 最大行数定義
    static const int MaxItemCount = 1;

    int m_CurrentSelectPos;
    int m_CurrentMaxPosNum;

    LaunchRange m_LaunchRangeList[MaxItemCount];
};
