﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include "TestAppSimple_SceneCommon.h"

class MetaInfoScene : public SceneCommon
{
    NN_DISALLOW_COPY(MetaInfoScene);

public:
    MetaInfoScene() NN_NOEXCEPT : m_CurrentPage(1), m_LastPage(1) {};
    virtual ~MetaInfoScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    void SetApplicationInfo() NN_NOEXCEPT;

private:
    // 項目(Item)と値(Value)の最大文字数定義(仮)
    static const size_t MaxItemSize = 32;
    static const size_t MaxValueSize = 64;
    // meta情報表示の最大行数定義
    static const int MaxItemCount = 17;

    struct DispayInfo
    {
        char item[MaxItemSize];
        char value[MaxValueSize];
    };

    std::vector<DispayInfo> m_DisplayList;
    int m_CurrentPage;
    int m_LastPage;

    SceneCommon::TouchRange m_NextPageRange;
    SceneCommon::TouchRange m_BackPageRange;
};
