﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Common.h>
#include <nn/nn_ApplicationId.h>

#include "TestAppSimple_Hash.h"

struct MetaInfo
{
    std::string item;
    std::string value;
};

const size_t MetaInfoMaxCount = 128;

extern char ExpectedHash[Hash::Sha1MaxStrSize + 1];
extern MetaInfo MetaInfoList[MetaInfoMaxCount];
// (SIGLO-52835) BCAT が有効かどうかの(グローバル)フラグ定義
extern bool IsBcatSettingEnabled;

// RomFs内のファイルを読み込んで上記静的変数に展開する関数
void ReadHashValueFileData() NN_NOEXCEPT;
void ReadMetaInfoListFileData() NN_NOEXCEPT;
nn::ApplicationId GetApplicationId() NN_NOEXCEPT;
