﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include "TestAppSimple_SceneCommon.h"

class HeadlineScene : public SceneCommon
{
    NN_DISALLOW_COPY(HeadlineScene);

public:
    HeadlineScene() NN_NOEXCEPT;
    virtual ~HeadlineScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    enum State
    {
        State_None,
        State_Jump,
    };

    struct PageRange
    {
        SceneCommon::RangePackage range;
        NextAction page;
    };

    State m_State;
    PageRange m_PageRangeList[PageCountMax];
    NextAction m_SelectedPage;
    int m_CurrentSelectPos;
};
