﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

static const uint32_t ApplicationHeapSize = 64 * 1024 * 1024;

void InitializeGraphicSystem() NN_NOEXCEPT;
void FinalizeGraphicSystem() NN_NOEXCEPT;
bool IsGraphicSystemInitialized() NN_NOEXCEPT;

void InitializeDebugFontWriter(nn::gfx::util::DebugFontTextWriter* inWriter) NN_NOEXCEPT;
void FinalizeDebugFontWriter(nn::gfx::util::DebugFontTextWriter* inWriter) NN_NOEXCEPT;
void ProcFrame(nn::gfx::util::DebugFontTextWriter* inWriter) NN_NOEXCEPT;
