﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "TestAppSimple_EcServiceTypes.h"

#if defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON ) && defined( NN_BUILD_CONFIG_SPEC_NX )
// NX 環境ではライブラリで機能が提供される

#else // defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON ) && defined( NN_BUILD_CONFIG_SPEC_NX )
// Generic 環境用の代替用のダミー関数を用意する
namespace nn { namespace ec {

    namespace {

        ConsumableServiceItemId g_ItemId = { "EcOcsiItem" };
    }

    bool ConsumableServiceItemId::IsValid() const NN_NOEXCEPT
    {
        return true;
    }

    bool ConsumableServiceItemRightData::IsValid() const NN_NOEXCEPT
    {
        return true;
    }

    ConsumableServiceItemId ConsumableServiceItemRightData::GetConsumableServiceItemId() const NN_NOEXCEPT
    {
        return g_ItemId;
    }

    bool ConsumableServiceItemRightData::IsServiceProvidableOnLocal() const NN_NOEXCEPT
    {
        return false;
    }

}} // namespace nn::ec
#endif // defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON ) && defined( NN_BUILD_CONFIG_SPEC_NX )

void EcOcsiRightList::Cleanup() NN_NOEXCEPT
{
    std::memset(infos, 0, sizeof(infos));
    count = 0;
}

void EcOcsiRightList::CheckAll(bool value) NN_NOEXCEPT
{
    for (int i = 0; i < count; i++)
    {
        infos[i].isSelected = value;;
    }
}

bool EcOcsiRightList::Switch(int index) NN_NOEXCEPT
{
    if (index >= 0 && index < count)
    {
        infos[index].isSelected = !infos[index].isSelected;
        return true;
    }
    return false;
}

bool EcOcsiRightList::IsValid() const NN_NOEXCEPT
{
    auto valid = true;
    for (int i = 0; i < count; i++)
    {
        if (!infos[i].rightData.IsValid())
        {
            valid = false;
        }
    }
    return (count > 0) && valid;
}

int EcOcsiRightList::GetSelectedCount() const NN_NOEXCEPT
{
    auto selected = 0;
    for (int i = 0; i < count; i++)
    {
        if (infos[i].isSelected)
        {
            selected++;
        }
    }
    return selected;
}

void EcOcsiRightList::PrintLog() const NN_NOEXCEPT
{
#if defined( TESTAPP_ENABLE_EC_DEBUG )
    for (int i = 0; i < count; i++)
    {
        auto& right = infos[i].rightData;
        if (right.IsValid())
        {
            auto id = right.GetConsumableServiceItemId();
            TESTAPP_EC_DEBUG_LOG("ItemId[%d]: %s \n", i, id.value);
        }
    }
#endif // defined( TESTAPP_ENABLE_EC_DEBUG )
}

void EcCatalog::Cleanup() NN_NOEXCEPT
{
    list.reset(nullptr);
    map.clear();
}

bool EcCatalog::SelectConsumable(int index) NN_NOEXCEPT
{
    selectedConsumableIndex = HasConsumable(index) ? index : -1;
    selectedConsumableItemIndex = -1;
    return selectedConsumableIndex >= 0;
}

bool EcCatalog::IsConsumableSelected() const NN_NOEXCEPT
{
    return HasConsumable(selectedConsumableIndex);
}

bool EcCatalog::SelectConsumableItem(int index) NN_NOEXCEPT
{
    selectedConsumableItemIndex = HasConsumableItem(index) ? index : -1;
    return selectedConsumableItemIndex >= 0;
}

bool EcCatalog::IsConsumableItemSelected() const NN_NOEXCEPT
{
    return HasConsumableItem(selectedConsumableItemIndex);
}

int EcCatalog::GetConsumableCount() const NN_NOEXCEPT
{
    return (list) ? static_cast<int>(list->consumables.size()) : 0;
}

bool EcCatalog::HasConsumable(int index) const NN_NOEXCEPT
{
    return (index >= 0) && (index < GetConsumableCount());
}

const EcConsumable* EcCatalog::GetConsumable(int index) const NN_NOEXCEPT
{
    return HasConsumable(index) ? list->consumables[index].get() : nullptr;
}

const EcConsumable* EcCatalog::GetSelectedConsumable() const NN_NOEXCEPT
{
    return GetConsumable(selectedConsumableIndex);
}

bool EcCatalog::IsConsumableItemInquired() const NN_NOEXCEPT
{
    return FindConsumableItemResponse() != nullptr;
}

int EcCatalog::GetConsumableItemCount() const NN_NOEXCEPT
{
    auto response = FindConsumableItemResponse();
    if (response)
    {
        return static_cast<int>(response->consumableItems.size());
    }
    return 0;
}

bool EcCatalog::HasConsumableItem(int index) const NN_NOEXCEPT
{
    return (index >= 0) && (index < GetConsumableItemCount());
}

const EcConsumableItem* EcCatalog::GetConsumableItem(int index) const NN_NOEXCEPT
{
    auto response = FindConsumableItemResponse();
    if (response)
    {
        if ((index >= 0) && (index < static_cast<int>(response->consumableItems.size())))
        {
            return response->consumableItems[index].get();
        }
    }
    return nullptr;
}

const EcConsumableItem* EcCatalog::GetSelectedConsumableItem() const NN_NOEXCEPT
{
    return GetConsumableItem(selectedConsumableItemIndex);
}

const EcConsumableItemResponse* EcCatalog::FindConsumableItemResponse() const NN_NOEXCEPT
{
    auto consumable = GetSelectedConsumable();
    if (consumable)
    {
        auto& id = consumable->consumableId;
        auto it = map.find(id);
        if (it != map.end())
        {
            return it->second.get();
        }
    }
    return nullptr;
}
