﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>

#if defined( NN_SDK_BUILD_DEBUG ) || defined( NN_SDK_BUILD_DEVELOP )

// DEBUG/DEVELOP ビルド時のみデバッグ有効化が可能
#define TESTAPP_ENABLE_EC_DEBUG

// DEBUG/DEVELOP ビルド時のログ
#define TESTAPP_EC_LOG(...)        NN_LOG( "[TestAppEc] " __VA_ARGS__ )
#else

// RELEASE ビルド時はログ出力なし
#define TESTAPP_EC_LOG(...)        static_cast<void>(0)
#endif // defined( NN_SDK_BUILD_DEBUG ) || defined( NN_SDK_BUILD_DEVELOP )

// デバッグ専用のログ
#if defined( TESTAPP_ENABLE_EC_DEBUG )
#define TESTAPP_EC_DEBUG_LOG(...)  NN_LOG( "[TestAppEcDebug] " __VA_ARGS__ )
#else
#define TESTAPP_EC_DEBUG_LOG(...)  static_cast<void>(0)
#endif // defined( TESTAPP_ENABLE_EC_DEBUG )

// HORIZON-NX 時のみ下記機能の有効化が可能
#if defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON ) && defined( NN_BUILD_CONFIG_SPEC_NX )

// EC サービスに接続（通常は有効にしておく、ダミー実装するなら無効）
#define TESTAPP_ENABLE_EC_ACCESS

// HORIZON-NX かつ TESTAPP_ENABLE_EC_DEBUG ならば下記機能の有効化が可能
#if defined( TESTAPP_ENABLE_EC_DEBUG )

// 消費型サービスアイテムの権利購入（通常は無効にしておく）
//#define TESTAPP_ENABLE_EC_OCSI_PURCHASE

#endif // defined( TESTAPP_ENABLE_EC_DEBUG )
#endif // defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON ) && defined( NN_BUILD_CONFIG_SPEC_NX )
