﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account.h>
#include <nn/err.h>
#include <nn/nn_ApplicationId.h>

#include "TestAppSimple_EcServiceTypes.h"
#include "TestAppSimple_WorkContractor.h"

class UserSelector;

// アプリ内アイテム一覧の照会
class EcCataloger : public Work
{
public:
    EcCataloger() NN_NOEXCEPT;
    virtual ~EcCataloger() NN_NOEXCEPT NN_OVERRIDE;

    void PrepareToInquireList(UserSelector* pUserSelector) NN_NOEXCEPT;
    void PrepareToInquireList(const nn::account::Uid& uid) NN_NOEXCEPT;
    void PrepareToInquireItem(const nn::account::Uid& uid, const EcCatalog& catalog) NN_NOEXCEPT;

    const nn::err::ErrorCode& GetErrorCode() const NN_NOEXCEPT;
    bool UpdateCatalog(EcCatalog* catalog) NN_NOEXCEPT;

protected:
    enum Request
    {
        Request_None,
        Request_InquireList,
        Request_InquireItem,
    };

    Request m_Request;
    UserSelector* m_pUserSelector;
    nn::account::Uid m_Uid;
    std::string m_ConsumableId;
    nn::err::ErrorCode m_ErrorCode;
    std::unique_ptr<EcConsumableResponse> m_ListReponse;
    std::unique_ptr<EcConsumableItemResponse> m_ItemReponse;

    void Prepare(Request request, const nn::account::Uid& uid, UserSelector* pUserSelector, const char* pConsumableId) NN_NOEXCEPT;

    bool UpdateCatalogList(EcCatalog* catalog) NN_NOEXCEPT;
    bool UpdateCatalogItem(EcCatalog* catalog) NN_NOEXCEPT;

    virtual bool Exeute() NN_NOEXCEPT NN_OVERRIDE;
    nn::Result InquireList() NN_NOEXCEPT;
    nn::Result InquireItem() NN_NOEXCEPT;
    nn::Result Inquire(std::unique_ptr<char[]>& json, size_t& size, const char* url) NN_NOEXCEPT;
};

// アプリ内アイテムの詳細ページ表示
class EcConsumableItemShower : public Work
{
public:
    EcConsumableItemShower() NN_NOEXCEPT;
    virtual ~EcConsumableItemShower() NN_NOEXCEPT NN_OVERRIDE;

    void PrepareToConsumableItemDetail(const nn::ApplicationId& applicationId, const nn::account::Uid& uid, const EcCatalog& catalog) NN_NOEXCEPT;

protected:
    enum Request
    {
        Request_None,
        Request_ConsumableItemDetail,
    };

    Request m_Request;
    nn::ApplicationId m_ApplicationId;
    nn::account::Uid m_Uid;
    std::string m_ConsumableId;
    int64_t m_NsUid;

    virtual bool Exeute() NN_NOEXCEPT NN_OVERRIDE;
    nn::Result ShowShopConsumableItemDetail() NN_NOEXCEPT;
};
