﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account.h>

#include "TestAppSimple_WorkContractor.h"

// ユーザー選択
class UserSelector : public Work
{
public:
    UserSelector() NN_NOEXCEPT;
    virtual ~UserSelector() NN_NOEXCEPT NN_OVERRIDE;

    void Prepare(bool isNsaRequired) NN_NOEXCEPT;

    const nn::account::Uid& GetUid() const NN_NOEXCEPT;
    const nn::account::Nickname& GetNickname() const NN_NOEXCEPT;
    const nn::account::NetworkServiceAccountId& GetNsaId() const NN_NOEXCEPT;

protected:
    nn::account::UserSelectionSettings m_Setting;
    nn::account::Uid m_Uid;
    nn::account::Nickname m_Nickname;
    nn::account::NetworkServiceAccountId m_NsaId;

    virtual bool Exeute() NN_NOEXCEPT NN_OVERRIDE;
    nn::Result SelectUser() NN_NOEXCEPT;
    nn::Result InquireNsaId() NN_NOEXCEPT;
};

// ネットワーク接続
class NetworkConnector : public Work
{
public:
    NetworkConnector() NN_NOEXCEPT;
    virtual ~NetworkConnector() NN_NOEXCEPT NN_OVERRIDE;

    void Prepare() NN_NOEXCEPT;

protected:
    virtual bool Exeute() NN_NOEXCEPT NN_OVERRIDE;
};
