﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/bcat/bcat_DeliveryCacheProgress.h>

#include "TestAppSimple_SceneCommon.h"

class BcatScene : public SceneCommon
{
    NN_DISALLOW_COPY(BcatScene);

public:
    NN_IMPLICIT BcatScene() NN_NOEXCEPT;
    virtual ~BcatScene() NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    struct BcatFile
    {
        std::string name;
        nn::Bit64 digest[2];

        explicit BcatFile(const std::string& inName) NN_NOEXCEPT
        {
            name = inName;
        }
    };

    struct BcatDirectory
    {
        std::string name;
        std::vector<BcatFile> fileList;

        explicit BcatDirectory(const std::string& inName) NN_NOEXCEPT
        {
            name = inName;
        }
    };

    std::vector<BcatDirectory> m_BcatDirList;

private:
    void EnterDirectoryHandle() NN_NOEXCEPT;
    void ResetBcatDirRangeList() NN_NOEXCEPT;
    void DrawAnimationDots(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void DrawReadingInfo(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void DrawSyncingDeliveryCache(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void DrawBcatDirectoryList(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void DrawBcatFileList(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;

private:
    void RequestDeliveryCacheSync() NN_NOEXCEPT;
    void WaitForDeliveryCacheSyncDone(nn::bcat::DeliveryCacheProgress* inPrg) NN_NOEXCEPT;

    void ReadBcatFiles() NN_NOEXCEPT;
    nn::Result MountDeliveryCacheStorage() NN_NOEXCEPT;
    void EnumerateAllFiles() NN_NOEXCEPT;

    static void ProcessBcatFunctionStatic(void* inPtr) NN_NOEXCEPT;
    int StartReadBcatFilesListAsync() NN_NOEXCEPT;
    void StopReadBcatFilesListAsync() NN_NOEXCEPT;

    int StartBcatRequestSyncDeliveryCacheAsync() NN_NOEXCEPT;
    void StopBcatRequestSyncDeliveryCacheAsync() NN_NOEXCEPT;

private:
    // BCAT 画面ページ全体の状態定義
    enum State
    {
        State_None,
        State_ShowDirectories,
        State_ShowFiles,
        State_StartReadFiles,
        State_ReadingFiles,
        State_StartRequestSync,
        State_SyncingDeliveryCache,
    };

    State m_State;

    int m_CurrentSelectPos;
    int m_CurrentMaxPosNum;
    int m_CurrentPage;
    int m_LastPage;

    int m_CurrentDirPage;
    int m_LastDirPage;

    int m_ReadingCalcCount;

    std::string m_CurrentProgressStatus;
    std::string m_GetCuurentDirectoryName;
    std::string m_GetCuurentFileName;
    int64_t m_GetCurrentDownloaded;
    int64_t m_GetCurrentTotal;
    int64_t m_GetWholeDownloaded;
    int64_t m_GetWholeTotal;

    nn::Result m_LastUpdateProcessResult;
    nn::Result m_LastRequestProcessResult;

    BcatDirectory* m_SelectedDirectoryPtr;

    SceneCommon::RangePackage m_UpdateFilesRange;
    SceneCommon::RangePackage m_RequestSyncRange;

    // BCAT ディレクトリの一覧表示の最大行数定義
    static const int MaxDirectoryItemCount = 8;
    static const int MaxFileItemCount = 11;

    SceneCommon::TouchRange m_BcatDirRangeList[MaxDirectoryItemCount];
    SceneCommon::RangePackage m_BackPageRange;
    SceneCommon::RangePackage m_NextPageRange;

    SceneCommon::TouchRange m_BackDirectoryRange;

private:
    nn::os::ThreadType m_BcatProcessThread;

    bool m_IsReadingBcatFiles;
    bool m_IsStopReadingBcatFiles;

    bool m_IsSyncingDeliveryCache;
    bool m_IsStopSyncingDeliveryCache;
};
