﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <list>
#include <nn/account/account_Types.h>

#include "TestAppSimple_SceneCommon.h"

class AccountScene : public SceneCommon
{
    NN_DISALLOW_COPY(AccountScene);

public:
    AccountScene() NN_NOEXCEPT;
    virtual ~AccountScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    void DrawUserName(nn::gfx::util::DebugFontTextWriter* writer, bool inAlreadyFlag,
        const std::string& inUserName) NN_NOEXCEPT;
    void DrawLastResult(nn::gfx::util::DebugFontTextWriter* writer, bool inAlreadyFlag,
        const std::string& inResultString, uint32_t inResultValue) NN_NOEXCEPT;
    void DrawOpenedUserList(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;

private:
    int EnsureNSAProcess() NN_NOEXCEPT;
    void GetUserHandle(nn::account::UserHandle* outHandle) NN_NOEXCEPT;
    void CheckNetworkConnection() NN_NOEXCEPT;
    void EnsureNetworkServiceAccount(const nn::account::UserHandle& inHandle) NN_NOEXCEPT;

    void EnsureSaveDataProcess() NN_NOEXCEPT;

private:
    enum class State
    {
        None,
        Ensuring,
        EnsuringSaveData,
        OpenUser,
        CloseUser,
    };

    State m_State;

    bool m_IsAlreadyEnsured;
    bool m_IsAlreadyEnsuredSaveData;

    std::string m_UserName;
    uint32_t m_EnsureNSAResultValue;
    std::string m_EnsureNSAResultString;

    std::string m_UserNameForSaveData;
    uint32_t m_EnsureSaveDataResultValue;
    std::string m_EnsureSaveDataResultString;

    SceneCommon::RangePackage m_EnsureNSARange;
    SceneCommon::RangePackage m_EnsureSaveDataRange;

private:
    struct DisplayUserInfo
    {
        nn::account::Uid id;
        std::string name;
        SceneCommon::RangePackage closeButton;
    };

    std::list<DisplayUserInfo> m_DisplayOpenedUserList;

    SceneCommon::RangePackage m_OpenUserRange;

    bool m_IsTemporaryOpened;
    int m_CurrentSelectPos;
    int m_CurrentMaxPosNum;
    nn::account::Uid m_SelectedCloseUserId;

    void OpenUser() NN_NOEXCEPT;
    void CloseUser() NN_NOEXCEPT;
};
