﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <list>

#include <nn/nn_Macro.h>
#include <nn/account/account_Types.h>

class AccountManager
{
    NN_DISALLOW_COPY(AccountManager);
    NN_DISALLOW_MOVE(AccountManager);
private:
    // シングルトン扱いにするため private 指定
    AccountManager() NN_NOEXCEPT;

public:
    // シングルトンのインスタンスを取得するための口
    static AccountManager& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(AccountManager, s_Instance);
        return s_Instance;
    }

public:
    struct UserInfo
    {
        nn::account::Uid id;
        std::string name;
        nn::account::UserHandle handle;
    };

    // アプレットを用いてアカウントユーザーを Open する
    // 返り値が true であれば Open 成功で pOutInfo に Open したユーザ情報が入る。
    // false であれば選択が中断されたか Open 失敗で pOutInfo にはなにも入らない。
    bool OpenUserWithSelectorApplet(UserInfo* pOutInfo) NN_NOEXCEPT;

    // 指定 Uid のユーザーを Close する
    void CloseUser(const nn::account::Uid& inUid) NN_NOEXCEPT;

    // 指定 Uid の( Open 済)ユーザー情報を取得する
    // 返り値が true であれば pOutUserInfo に指定のユーザー情報が入る。
    // false であれば指定 Uid は Open していないユーザーで pOutUserInfo には何も入らない。
    bool GetOpenedUserInfo(const nn::account::Uid& inUid, UserInfo* pOutUserInfo) NN_NOEXCEPT;

    // [マルチプログラムアプリケーション向け] 保持している Open 済ユーザー情報の一括取得用関数
    void GetOpenedUserList(std::list<UserInfo>* outOpenedUserList) NN_NOEXCEPT;

public:
    // [マルチプログラムアプリケーション向け]
    // nn::account::PopOpenUsers() を呼び出し、Open 済ユーザーが存在していればクラス内部にその情報を保持する
    bool PopOpenUsers() NN_NOEXCEPT;
    //  nn::account::PushOpenUsers() を呼び出す
    void PushOpenUsers() NN_NOEXCEPT;

private:
    std::list<UserInfo> m_OpenedUserList;
};

