﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include "TestAppSimple_SceneCommon.h"

class AbortDebugScene : public SceneCommon
{
    NN_DISALLOW_COPY(AbortDebugScene);

public:
    AbortDebugScene() NN_NOEXCEPT;
    virtual ~AbortDebugScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::Result ReadAbortResultValue() NN_NOEXCEPT;

    void ExecuteNullPointerAccess() NN_NOEXCEPT;
    void ExecuteStackOverflow() NN_NOEXCEPT;
    void ExecuteAbortResult() NN_NOEXCEPT;
    void ExecuteQuickExit() NN_NOEXCEPT;

private:
    enum State
    {
        State_None,
        State_AbortReady,
        State_Aborting,
    };

    State m_State;

    int m_CurrentSelectPos;
    int m_CurrentMaxPosNum;

    SceneCommon::RangePackage* m_SelectedRangePtr;

    std::string m_AbortResultValue;
    SceneCommon::RangePackage m_DoAbortRange;
    SceneCommon::RangePackage m_NullPointerAccessRange;
    SceneCommon::RangePackage m_StackOverflowRange;
    SceneCommon::RangePackage m_QuickExitRange;

    std::vector<SceneCommon::RangePackage*> m_DisplayRangePtrList;

    WarningView m_WarningView;
    // メッセージ中で変動する箇所の配列インデックス
    size_t m_AbortMsgIdx;
};
