﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using System.Drawing.Imaging;

namespace MakeTestApplication
{
    internal class PictureCreator
    {
        public static void CreateBitmapIconFile(string inSaveFilePath, SettingParams inSetParam, string inSetLanguage)
        {
            // アイコン画像の仕様に合わせて BMP 24bit の 1024 x 1024 の画像を出力する
            int canvasWidth = 1024;
            int canvasHeight = 1024;
            using (var canvas = new Bitmap(canvasWidth, canvasHeight, PixelFormat.Format24bppRgb))
            {
                using (var g = Graphics.FromImage(canvas))
                {
                    // 描画するフォントの設定
                    string fontName = "Arial";
                    float fontSize = 65.0f;
                    var fontStyle = FontStyle.Bold;
                    var strColor = Brushes.White;

                    // 表示文字列はアイコン全体に対して中央寄せにする
                    var strFormat = new StringFormat();
                    strFormat.Alignment = StringAlignment.Center;
                    strFormat.LineAlignment = StringAlignment.Near;

                    // ひとまず黒地の背景に設定
                    g.FillRectangle(Brushes.Black, g.VisibleClipBounds);

                    float posY = 150.0f;
                    float gap = 200.0f;
                    using (var idFont = new Font(fontName, fontSize * 1.05f, fontStyle))
                    {
                        var idRect = new RectangleF(0.0f, posY, canvasWidth, 200.0f);
                        // アプリID を描く
                        g.DrawString(inSetParam.MetaProgramId, idFont, strColor, idRect, strFormat);
                    }

                    posY += gap;
                    using (var verFont = new Font(fontName, fontSize * 1.6f, fontStyle))
                    {
                        var rvRect = new RectangleF(0.0f, posY, canvasWidth, 300.0f);
                        string rvStr = string.Format("Rv. {0}", inSetParam.ReleaseVersion);
                        // ReleaseVersion の値を描く
                        g.DrawString(rvStr, verFont, strColor, rvRect, strFormat);

                        posY += gap;
                        var pvRect = new RectangleF(0.0f, posY, canvasWidth, 300.0f);
                        string pvStr = string.Format("Pv. {0}", inSetParam.PrivateVersion);
                        // PrivateVersion の値を描く
                        g.DrawString(pvStr, verFont, strColor, pvRect, strFormat);
                    }

                    posY += (gap + 50.0f);
                    using (var langFont = new Font(fontName, fontSize, fontStyle))
                    {
                        var langRect = new RectangleF(0.0f, posY, canvasWidth, 200.0f);
                        // 言語の文字列を描く
                        g.DrawString(inSetLanguage, langFont, strColor, langRect, strFormat);
                    }
                }

                // 指定したパスにファイルとして保存
                canvas.Save(inSaveFilePath);
            }
        }
    }
}
