﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Runtime.Serialization;

namespace PCToolTester
{
    [DataContract]
    public partial class TestSet
    {
        [DataMember]
        public Test[] Tests;

        [DataMember]
        public Constant[] Constants;
    }

    [DataContract]
    public partial class Test
    {
        [DataMember]
        public string Name;

        [DataMember]
        public string ExecuteFilePath;

        [DataMember]
        public string Arguments;

        [DataMember]
        public string Result;

        [DataMember]
        public Constant[] Constants;

        [DataMember]
        public string[] PrepareEmptyDirectories;

        [DataMember]
        public Outputs[] Outputs;
    }

    [DataContract]
    public partial class Outputs
    {
        [DataMember]
        public string Actual;

        [DataMember]
        public string Expected;
    }

    [DataContract]
    public partial class Constant
    {
        [DataMember]
        public string Name;

        [DataMember]
        public string Value;
    }
}
