﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections;
using System.Collections.Generic;

namespace NintendoWare.Spy.Tests
{
    [TestClass]
    public class BinarySearchUtilityTests
    {
        public class MinMax<T>
            where T : IComparable
        {
            public T Min { get; set; }
            public T Max { get; set; }

            public MinMax(T min, T max)
            {
                this.Min = min;
                this.Max = max;
            }

            public bool Contains(T value)
            {
                return this.Min.CompareTo(value) <= 0 && value.CompareTo(this.Max) < 0;
            }
        }

        [TestClass]
        public class MinMaxTest
        {
            [TestMethod]
            public void TestMinMax()
            {
                Assert.AreEqual(false, new MinMax<int>(0, 2).Contains(-1));
                Assert.AreEqual(true, new MinMax<int>(0, 2).Contains(0));
                Assert.AreEqual(true, new MinMax<int>(0, 2).Contains(1));
                Assert.AreEqual(false, new MinMax<int>(0, 2).Contains(2));
                Assert.AreEqual(false, new MinMax<int>(0, 2).Contains(3));
            }
        }

        private class Data<T>
        {
            public T Value { get; set; }

            public Data(T value)
            {
                this.Value = value;
            }
        }

        [TestMethod]
        public void TestBinarySearch_IList()
        {
            ArrayList list = new ArrayList();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, selector));
            Assert.IsTrue(new MinMax<int>(1, 4).Contains(BinarySearchUtility.BinarySearch(list, 1.0, selector)));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, selector));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2.0, selector));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, selector));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector));
        }

        [TestMethod]
        public void TestBinarySearch_IListT()
        {
            List<Data<double>> list = new List<Data<double>>();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value));
            Assert.IsTrue(new MinMax<int>(1, 4).Contains(BinarySearchUtility.BinarySearch(list, 1, it => it.Value)));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2, it => it.Value));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value));
        }

        [TestMethod]
        public void TestBinarySearch_IList_FirstFound1()
        {
            ArrayList list = new ArrayList();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.FirstFound;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.IsTrue(new MinMax<int>(1, 4).Contains(BinarySearchUtility.BinarySearch(list, 1.0, selector, options)));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_FirstFound2()
        {
            ArrayList list = new ArrayList();

            // 同じ値がリストの先頭にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.FirstFound;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.IsTrue(new MinMax<int>(0, 3).Contains(BinarySearchUtility.BinarySearch(list, 0.0, selector, options)));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_FirstFound3()
        {
            ArrayList list = new ArrayList();

            // 同じ値がリストの末尾にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.FirstFound;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~2, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.IsTrue(new MinMax<int>(3, 6).Contains(BinarySearchUtility.BinarySearch(list, 3.0, selector, options)));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_FirstFound1()
        {
            List<Data<double>> list = new List<Data<double>>();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.FirstFound;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.IsTrue(new MinMax<int>(1, 4).Contains(BinarySearchUtility.BinarySearch(list, 1.0, it => it.Value, options)));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_FirstFound2()
        {
            List<Data<double>> list = new List<Data<double>>();

            // 同じ値がリストの先頭にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.FirstFound;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.IsTrue(new MinMax<int>(0, 3).Contains(BinarySearchUtility.BinarySearch(list, 0.0, it => it.Value, options)));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1.0, it => it.Value, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_FirstFound3()
        {
            List<Data<double>> list = new List<Data<double>>();

            // 同じ値がリストの末尾にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.FirstFound;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1.0, it => it.Value, options));
            Assert.AreEqual(~2, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.IsTrue(new MinMax<int>(3, 6).Contains(BinarySearchUtility.BinarySearch(list, 3.0, it => it.Value, options)));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_SmallestIndex1()
        {
            ArrayList list = new ArrayList();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.SmallestIndex;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_SmallestIndex2()
        {
            ArrayList list = new ArrayList();

            // 同じ値がリストの先頭にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.SmallestIndex;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_SmallestIndex3()
        {
            ArrayList list = new ArrayList();

            // 同じ値がリストの末尾にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.SmallestIndex;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~2, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_SmallestIndex1()
        {
            List<Data<double>> list = new List<Data<double>>();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.SmallestIndex;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1, it => it.Value, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_SmallestIndex2()
        {
            List<Data<double>> list = new List<Data<double>>();

            // 同じ値がリストの先頭にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.SmallestIndex;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1, it => it.Value, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_SmallestIndex3()
        {
            List<Data<double>> list = new List<Data<double>>();

            // 同じ値がリストの末尾にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.SmallestIndex;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1, it => it.Value, options));
            Assert.AreEqual(~2, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_BiggestIndex1()
        {
            ArrayList list = new ArrayList();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.BiggestIndex;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_BiggestIndex2()
        {
            ArrayList list = new ArrayList();

            // 同じ値がリストの先頭にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.BiggestIndex;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IList_BiggestIndex3()
        {
            ArrayList list = new ArrayList();

            // 同じ値がリストの末尾にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.BiggestIndex;
            Func<object, double> selector = it => ((Data<double>)it).Value;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1.0, selector, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0.0, selector, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, selector, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1.0, selector, options));
            Assert.AreEqual(~2, BinarySearchUtility.BinarySearch(list, 1.5, selector, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 2.0, selector, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 2.5, selector, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3.0, selector, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4.0, selector, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_BiggestIndex1()
        {
            List<Data<double>> list = new List<Data<double>>();

            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.BiggestIndex;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1, it => it.Value, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_BiggestIndex2()
        {
            List<Data<double>> list = new List<Data<double>>();

            // 同じ値がリストの先頭にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.BiggestIndex;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(3, BinarySearchUtility.BinarySearch(list, 1, it => it.Value, options));
            Assert.AreEqual(~4, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(4, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~5, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }

        [TestMethod]
        public void TestBinarySearch_IListT_BiggestIndex3()
        {
            List<Data<double>> list = new List<Data<double>>();

            // 同じ値がリストの末尾にある場合。
            list.Add(new Data<double>(0));
            list.Add(new Data<double>(1));
            list.Add(new Data<double>(2));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));
            list.Add(new Data<double>(3));

            var options = BinarySearchUtility.Options.BiggestIndex;

            Assert.AreEqual(~0, BinarySearchUtility.BinarySearch(list, -1, it => it.Value, options));
            Assert.AreEqual(0, BinarySearchUtility.BinarySearch(list, 0, it => it.Value, options));
            Assert.AreEqual(~1, BinarySearchUtility.BinarySearch(list, 0.5, it => it.Value, options));
            Assert.AreEqual(1, BinarySearchUtility.BinarySearch(list, 1, it => it.Value, options));
            Assert.AreEqual(~2, BinarySearchUtility.BinarySearch(list, 1.5, it => it.Value, options));
            Assert.AreEqual(2, BinarySearchUtility.BinarySearch(list, 2, it => it.Value, options));
            Assert.AreEqual(~3, BinarySearchUtility.BinarySearch(list, 2.5, it => it.Value, options));
            Assert.AreEqual(5, BinarySearchUtility.BinarySearch(list, 3, it => it.Value, options));
            Assert.AreEqual(~6, BinarySearchUtility.BinarySearch(list, 4, it => it.Value, options));
        }
    }
}
