﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace NintendoWare.NnAtkSpyPlugin.Windows.Tests
{
    [TestClass()]
    public class DoubleToLucidStringConverterTests
    {
        [TestMethod()]
        public void ConvertTest()
        {
            var converter = new DoubleToLucidStringConverter();
            converter.Format = "{0:F1}";
            Assert.AreEqual("1.0", converter.Convert(1d, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("1.1", converter.Convert(1.05d, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("∞", converter.Convert(double.PositiveInfinity, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("-∞", converter.Convert(double.NegativeInfinity, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("NaN", converter.Convert(double.NaN, typeof(string), parameter: null, culture: null));
            converter.Format = "{0:F1} [sec]";
            Assert.AreEqual("1.0 [sec]", converter.Convert(1.0d, typeof(string), parameter: null, culture: null));
        }

        [TestMethod()]
        public void TestCeiling()
        {
            var converter = new DoubleToLucidStringConverter();
            converter.Format = "{0:F1}";
            converter.Ceiling = 0.1;
            Assert.AreEqual("0.2", converter.Convert(0.15, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("0.1", converter.Convert(0.10, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("0.1", converter.Convert(0.05, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("0.0", converter.Convert(0.00, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("0.0", converter.Convert(-0.05, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("-0.1", converter.Convert(-0.10, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("-0.1", converter.Convert(-0.15, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("∞", converter.Convert(double.PositiveInfinity, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("-∞", converter.Convert(double.NegativeInfinity, typeof(string), parameter: null, culture: null));
            Assert.AreEqual("NaN", converter.Convert(double.NaN, typeof(string), parameter: null, culture: null));
        }
    }
}
