﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Diagnostics.CodeAnalysis;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// bfstm ファイルの入力テストです。(x86)
    /// </summary>
    [TestClass]
    [DeploymentItem(@"x86\Nintendo.Atk.Native.dll", "x86")]
    [SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1121:UseBuiltInTypeAlias", Justification = "バイナリのサイズを明示するため")]
    public class BfstmReaderX86Test
    {
        private const string BfstmDirectoryPath = @"Resources\\bfstm\";
        private const string RawDirectoryPath = @"Resources\\raw\";

        /// <summary>
        /// WaveBinaryInfo 読み込みテスト
        /// </summary>
        [TestMethod]
        [DeploymentItem(BfstmDirectoryPath + "sin2ch48kLoop.adpcm.bfstm", BfstmDirectoryPath)]
        [DeploymentItem(BfstmDirectoryPath + "sin-wn2ch48kLoop.pcm16.bfstm", BfstmDirectoryPath)]
        [DeploymentItem(BfstmDirectoryPath + "sin-wn2ch48k.adpcm.bfstm", BfstmDirectoryPath)]
        public void ReadWaveBinaryInfo()
        {
            BfstmReaderTest.ReadWaveBinaryInfo();
        }

        /// <summary>
        /// デコードテスト
        /// </summary>
        [TestMethod]
        [DeploymentItem(BfstmDirectoryPath + "sin-wn2ch48kLoop.pcm16.bfstm", BfstmDirectoryPath)]
        [DeploymentItem(BfstmDirectoryPath + "sin-wn2ch48k.adpcm.bfstm", BfstmDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48kLoop.pcm16.bfstm.ch0.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48kLoop.pcm16.bfstm.ch1.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48kLoop.pcm16.bfstm.ch2.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48kLoop.pcm16.bfstm.ch3.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48k.adpcm.bfstm.ch0.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48k.adpcm.bfstm.ch1.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48k.adpcm.bfstm.ch2.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin-wn2ch48k.adpcm.bfstm.ch3.raw.wav", RawDirectoryPath)]
        public void DecodeAll()
        {
            BfstmReaderTest.DecodeAll();
        }
    }
}
