﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testRepair_Utility.h"
#include <string>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/TargetConfigs/build_Os.h>

namespace {
    std::string GetWorkingDirectory(const char *argv0)
    {
        auto programPath = std::string(argv0);

        auto directoryEnd = programPath.rfind('\\');

        if (directoryEnd == std::string::npos)
        {
            NN_ABORT("Found not working directory: %s\n", argv0);
        }

        return programPath.substr(0, programPath.rfind('\\'));
    }
}

namespace nn
{
    namespace repair
    {
        nn::repair::FileSystem* CreateNnfsFileSystem();
    }
}

namespace nnt
{
namespace repair
{
    TestEnvironment::TestEnvironment()
    {
        m_WorkingDirectory = ::GetWorkingDirectory(nn::os::GetHostArgv()[0]);
        NN_LOG("WorkingDirectory: %s\n", m_WorkingDirectory.c_str());

        m_IsManuEnabled = 2 <= nn::os::GetHostArgc() && std::strcmp(nn::os::GetHostArgv()[1], "enable-manu") == 0;

        m_NnfsFileSystem = nn::repair::FileSystem::Create("nnfs");

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
        if (m_IsManuEnabled)
        {
            m_ManuFileSystem = nn::repair::FileSystem::Create("manu");
        }
#endif
    }

    std::string TestEnvironment::GetWorkingDirectory()
    {
        return m_WorkingDirectory;
    }

    std::shared_ptr<nn::repair::FileSystem> TestEnvironment::GetManuFileSystem() {
        return m_ManuFileSystem;
    }

    std::shared_ptr<nn::repair::FileSystem> TestEnvironment::GetNnfsFileSystem()
    {
        return m_NnfsFileSystem;
    }

    bool TestEnvironment::IsManuEnabled()
    {
        return m_IsManuEnabled;
    }

    TestEnvironment& GetTestEnv()
    {
        static TestEnvironment tenv;

        return tenv;
    }
}
}
