﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/nn_Log.h>
#include <nn/npns.h>
#include <nn/npns/npns_ApiSystem.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>
#include <nn/result/result_HandlingUtility.h>
#include "../../../Programs/Eris/Sources/Processes/npns/npns_Config.h"
#include <nnt/npnsUtil.h>

#define FULL
#define STATE
#define INFINITY_LOOP

namespace {

using namespace nn;
using namespace nnt::npns::util;

class NpnsStressTest : public nnt::npns::util::TestBase
{
protected:
    NpnsStressTest()
    {
#ifdef NN_BUILD_CONFIG_COMPILER_VC
        _set_abort_behavior( _WRITE_ABORT_MSG, _WRITE_ABORT_MSG);
#endif
    }
};

}

#ifdef FULL
TEST_F(NpnsStressTest, Flood)
{

    nn::Result result;
    nn::ApplicationId appId ={ 0x0100000000000000 };
    result = nn::npns::ListenTo(appId);
    NNT_ASSERT_RESULT_SUCCESS(result);

    nn::npns::NotificationToken token;
    nn::account::Uid uid ={ { 0x0123456789abcdefULL, 0xfedcba9876543210ULL } };
    result = nn::npns::CreateToken(&token, uid, appId);
    NNT_ASSERT_RESULT_SUCCESS(result);

    for (int i = 0; i < 64; ++i)
    {
        char buffer[64];
        util::SNPrintf(buffer, sizeof(buffer), "%d", i);
        PublishNotification(token, buffer);
    }

    nn::npns::NotificationData nd;
    while (nn::npns::Receive(&nd).IsSuccess())
    {
        NN_LOG("payload = %.*s\n", nd.GetPayloadSize(), nd.GetPayload());
    }

    result  = nn::npns::DestroyToken(uid, appId);
    NNT_ASSERT_RESULT_SUCCESS(result);

}
#endif

#if defined(FULL) || defined(STATE)
TEST_F(NpnsStressTest, SuspendResume)
{
    nn::Result result;

#ifdef INFINITY_LOOP
    for (;;)
#else
    for (int i = 0; i < 500; ++i)
#endif
    {
        result = nn::npns::Suspend();
        NNT_ASSERT_RESULT_SUCCESS(result);

        nn::npns::State state = nn::npns::GetState();
        GTEST_ASSERT_EQ(state, nn::npns::State_Suspend);

        result = nn::npns::Resume();
        NNT_ASSERT_RESULT_SUCCESS(result);

        PollState(nn::npns::State_Connected, nn::TimeSpan::FromMilliSeconds(std::rand() % 3000));
    }
}
#endif
