﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TestUtility;
using CsScripts;

namespace CsScriptsTest
{
    [TestClass]
    public class BootImageUtilityTest
    {
        public TestContext TestContext { get; set; }

        [TestMethod]
        public void BootImageUtilityTest_Basic()
        {
            using (var tempHolder = new ScopedTemporaryFileHolder(TestContext))
            {
                var targetHashListFile = tempHolder.CreateTemporaryFile(
@"Normal-K1.bct BECF7B8808F92FFAC4C5043C8EC11C31DDBF0E1CF349ACC85B2D000227BDF8CF
Normal-K2.bct 5667B6BA1D2AD1037E48472C86A0EBD0BBCCEE4FA5CB26FD2120F6524AE72EFA
Normal-K3.bct 8C2FC1A4E491F9B0AF5523528FC9FF0D3A34E986880486F7AA0320560806DB9D
Recovery-K1.bct FE75D7B3BAF3D16BF9996392CB813D582BAEECB28F32F30D08BD2F01BE841EA6
Recovery-K2.bct E81774D1985DFC5B1BACC46A5A15DEA05313B22EFECDA2A2206193B43093E334
Recovery-K3.bct B925A6D359EDB7D9688DA9B11E2C92CFF359C74C1785A04171B6ABCE8DCE24B8
Safe-K1.bct 5D648F014F7AE2F78085F729E1A5D6B2E2CC6A1CC70C8227C7770095D5A5A235
Safe-K2.bct A4F856D49CD2F21F5C5BBC52A172A32A442919C46BF173D34ADB628EC5B5146F
Safe-K3.bct 9716777E167DAC3DED58EC1648FEC84F554A8DC7F622D44DEFA77C5D11CFD700
");

                var sourceDirectory = tempHolder.CreateTemporaryDirectory();

                tempHolder.CreateTemporaryFile(
                    sourceDirectory,
                    "v0.11.0-Snapshot2.bootimage-hashlist.txt",
@"Normal-K1.bct BECF7B8808F92FFAC4C5043C8EC11C31DDBF0E1CF349ACC85B2D000227BDF8CF
Normal-K2.bct 5667B6BA1D2AD1037E48472C86A0EBD0BBCCEE4FA5CB26FD2120F6524AE72EFA
Normal-K3.bct 8C2FC1A4E491F9B0AF5523528FC9FF0D3A34E986880486F7AA0320560806DB9D
Recovery-K1.bct FE75D7B3BAF3D16BF9996392CB813D582BAEECB28F32F30D08BD2F01BE841EA6
Recovery-K2.bct E81774D1985DFC5B1BACC46A5A15DEA05313B22EFECDA2A2206193B43093E334
Recovery-K3.bct B925A6D359EDB7D9688DA9B11E2C92CFF359C74C1785A04171B6ABCE8DCE24B8
Safe-K1.bct C3D9B881115D0DCAA16C3EC4EF37FD3C4291911462A6553B308102A1F889D0CA
Safe-K2.bct 35783FCC8641282730799E3A551A9E4FA78E23D34C9B47ECDCE4885AEA762708
Safe-K3.bct DA81FD79F35579D606C770523BBBC16DA90A3D8216965B7E3E1F3A6204C6A398
Normal-K1.bl C926CB45B53E7A660C5D1F168DED5F19B7B422F58C2EA43B55E6C784C78E6A29
Normal-K2.bl BAF7BE88591E1867140077D48937265A2441DF423134F6B6F22C3BB2A58731DC
Normal-K3.bl CE996E3DA3DADDF8414CDDC2FF8C5BD6A2BA9E8C27A4099ACB9FAB7A97E4F69E
Recovery-K1.bl 59E4DAA704308D7F757B398FC0860D316F36AF595AEC2F2C9B7C01165BD39846
Recovery-K2.bl 1639F5D3E5E36B8E639649905A3C53A71D5AAD587EB158EB9D7D3C3346DA9E4E
Recovery-K3.bl BDD09F00A2FE675B1DA41AA97766E91DBCC823B1F15B787B2AEF7522010801FF
");

                tempHolder.CreateTemporaryFile(
                    sourceDirectory,
                    "EdevEp22.bootimage-hashlist.txt",
@"Normal-K1.bct 82D2CB60A7FF374AF189B593CF4477081832F8B540081A89BA666B44AC6C39ED
Normal-K2.bct D3EF287FD4B41FCA284CE8A6A9B1D5B9184EF95F0084110A3D68D13ED6261B8D
Normal-K3.bct 20601C8A2BE2D5A60F0D8702753BBF54527FFDF7176F3D0243942D87A9A41AD8
Recovery-K1.bct 7EF5F1C922746758E11A8C278314F22CB23CD8FD11914065ACADB492F85041EA
Recovery-K2.bct CA495B3D1A9EA75CE63FBA82AE8E9FA0F318D9CE4DAE5D4DD6F0877A3FDE34B4
Recovery-K3.bct BF1BC3BEAC4779464A6A4F37CA2178A29BB1EA3059E62C98B2B47BD82A956A91
Safe-K1.bct 5D648F014F7AE2F78085F729E1A5D6B2E2CC6A1CC70C8227C7770095D5A5A235
Safe-K2.bct A4F856D49CD2F21F5C5BBC52A172A32A442919C46BF173D34ADB628EC5B5146F
Safe-K3.bct 9716777E167DAC3DED58EC1648FEC84F554A8DC7F622D44DEFA77C5D11CFD700
Normal-K1.bl 4E3DFD455CB34863C0909B85CEE18A68483B03AB6B23EAC8CA4A05204A74455A
Normal-K2.bl C72980E877E1B9B8E2D87048C9482A3B7A00DAFFC016B610509CD3078F404564
Normal-K3.bl D44AC95BC934196712F363C6CA897CC71E1094C690C6A13255E80035DBD69F51
Recovery-K1.bl 0149E79C845E537FE082F3AA743798B70486509939A993761DB6C6BD94242C27
Recovery-K2.bl 47781F490B3936E7C5B6B1BD86DD229BD39DC49197B84A38700FD9ABA05BA552
Recovery-K3.bl 57D58AC1286D5C9A80198B4CAB45FADECBA6DC983CEBD1A1076F3BBA60FFE009
");

                Assert.AreEqual(
@"Normal-K1.bct BECF7B8808F92FFAC4C5043C8EC11C31DDBF0E1CF349ACC85B2D000227BDF8CF (Normal-K1.bct@v0.11.0-Snapshot2.bootimage-hashlist.txt)
Normal-K2.bct 5667B6BA1D2AD1037E48472C86A0EBD0BBCCEE4FA5CB26FD2120F6524AE72EFA (Normal-K2.bct@v0.11.0-Snapshot2.bootimage-hashlist.txt)
Normal-K3.bct 8C2FC1A4E491F9B0AF5523528FC9FF0D3A34E986880486F7AA0320560806DB9D (Normal-K3.bct@v0.11.0-Snapshot2.bootimage-hashlist.txt)
Recovery-K1.bct FE75D7B3BAF3D16BF9996392CB813D582BAEECB28F32F30D08BD2F01BE841EA6 (Recovery-K1.bct@v0.11.0-Snapshot2.bootimage-hashlist.txt)
Recovery-K2.bct E81774D1985DFC5B1BACC46A5A15DEA05313B22EFECDA2A2206193B43093E334 (Recovery-K2.bct@v0.11.0-Snapshot2.bootimage-hashlist.txt)
Recovery-K3.bct B925A6D359EDB7D9688DA9B11E2C92CFF359C74C1785A04171B6ABCE8DCE24B8 (Recovery-K3.bct@v0.11.0-Snapshot2.bootimage-hashlist.txt)
Safe-K1.bct 5D648F014F7AE2F78085F729E1A5D6B2E2CC6A1CC70C8227C7770095D5A5A235 (Safe-K1.bct@EdevEp22.bootimage-hashlist.txt)
Safe-K2.bct A4F856D49CD2F21F5C5BBC52A172A32A442919C46BF173D34ADB628EC5B5146F (Safe-K2.bct@EdevEp22.bootimage-hashlist.txt)
Safe-K3.bct 9716777E167DAC3DED58EC1648FEC84F554A8DC7F622D44DEFA77C5D11CFD700 (Safe-K3.bct@EdevEp22.bootimage-hashlist.txt)
",
                    BootImageUtility.FindMatchedHash(targetHashListFile.FullName, sourceDirectory.FullName));
            }
        }
    }
}
